# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..requests.bulk_job_callback import BulkJobCallbackParams
from ..requests.speech_to_text_translate_job_parameters import SpeechToTextTranslateJobParametersParams
from ..types.bulk_job_init_response_v_1 import BulkJobInitResponseV1
from ..types.files_download_response import FilesDownloadResponse
from ..types.files_upload_response import FilesUploadResponse
from ..types.job_status_v_1_response import JobStatusV1Response
from .raw_client import AsyncRawSpeechToTextTranslateJobClient, RawSpeechToTextTranslateJobClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SpeechToTextTranslateJobClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSpeechToTextTranslateJobClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSpeechToTextTranslateJobClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSpeechToTextTranslateJobClient
        """
        return self._raw_client

    def initialise(
        self,
        *,
        job_parameters: SpeechToTextTranslateJobParametersParams,
        ptu_id: typing.Optional[int] = None,
        callback: typing.Optional[BulkJobCallbackParams] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkJobInitResponseV1:
        """
        Get a job uuid, and storage folder details for speech to text tranlsate bulk job v1

        Parameters
        ----------
        job_parameters : SpeechToTextTranslateJobParametersParams
            Job Parameters for the bulk job

        ptu_id : typing.Optional[int]

        callback : typing.Optional[BulkJobCallbackParams]
            Parameters for callback URL

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkJobInitResponseV1
            Successful Response

        Examples
        --------
        from sarvamai import SarvamAI

        client = SarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )
        client.speech_to_text_translate_job.initialise(
            job_parameters={},
        )
        """
        _response = self._raw_client.initialise(
            job_parameters=job_parameters, ptu_id=ptu_id, callback=callback, request_options=request_options
        )
        return _response.data

    def get_status(
        self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> JobStatusV1Response:
        """
        Get the status of a speech to text translate bulk job V1

        Parameters
        ----------
        job_id : str
            The unique identifier of the job

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        JobStatusV1Response
            Successful Response

        Examples
        --------
        from sarvamai import SarvamAI

        client = SarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )
        client.speech_to_text_translate_job.get_status(
            job_id="job_id",
        )
        """
        _response = self._raw_client.get_status(job_id, request_options=request_options)
        return _response.data

    def start(
        self,
        job_id: str,
        *,
        ptu_id: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> JobStatusV1Response:
        """
        Start a speech to text translate bulk job V1

        Parameters
        ----------
        job_id : str
            The unique identifier of the job

        ptu_id : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        JobStatusV1Response
            Successful Response

        Examples
        --------
        from sarvamai import SarvamAI

        client = SarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )
        client.speech_to_text_translate_job.start(
            job_id="job_id",
        )
        """
        _response = self._raw_client.start(job_id, ptu_id=ptu_id, request_options=request_options)
        return _response.data

    def get_upload_links(
        self,
        *,
        job_id: str,
        files: typing.Sequence[str],
        ptu_id: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesUploadResponse:
        """
        Start a speech to text bulk job V1

        Parameters
        ----------
        job_id : str

        files : typing.Sequence[str]

        ptu_id : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesUploadResponse
            Successful Response

        Examples
        --------
        from sarvamai import SarvamAI

        client = SarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )
        client.speech_to_text_translate_job.get_upload_links(
            job_id="job_id",
            files=["files"],
        )
        """
        _response = self._raw_client.get_upload_links(
            job_id=job_id, files=files, ptu_id=ptu_id, request_options=request_options
        )
        return _response.data

    def get_download_links(
        self,
        *,
        job_id: str,
        files: typing.Sequence[str],
        ptu_id: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesDownloadResponse:
        """
        Start a speech to text bulk job V1

        Parameters
        ----------
        job_id : str

        files : typing.Sequence[str]

        ptu_id : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesDownloadResponse
            Successful Response

        Examples
        --------
        from sarvamai import SarvamAI

        client = SarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )
        client.speech_to_text_translate_job.get_download_links(
            job_id="job_id",
            files=["files"],
        )
        """
        _response = self._raw_client.get_download_links(
            job_id=job_id, files=files, ptu_id=ptu_id, request_options=request_options
        )
        return _response.data


class AsyncSpeechToTextTranslateJobClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSpeechToTextTranslateJobClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSpeechToTextTranslateJobClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSpeechToTextTranslateJobClient
        """
        return self._raw_client

    async def initialise(
        self,
        *,
        job_parameters: SpeechToTextTranslateJobParametersParams,
        ptu_id: typing.Optional[int] = None,
        callback: typing.Optional[BulkJobCallbackParams] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkJobInitResponseV1:
        """
        Get a job uuid, and storage folder details for speech to text tranlsate bulk job v1

        Parameters
        ----------
        job_parameters : SpeechToTextTranslateJobParametersParams
            Job Parameters for the bulk job

        ptu_id : typing.Optional[int]

        callback : typing.Optional[BulkJobCallbackParams]
            Parameters for callback URL

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkJobInitResponseV1
            Successful Response

        Examples
        --------
        import asyncio

        from sarvamai import AsyncSarvamAI

        client = AsyncSarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )


        async def main() -> None:
            await client.speech_to_text_translate_job.initialise(
                job_parameters={},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.initialise(
            job_parameters=job_parameters, ptu_id=ptu_id, callback=callback, request_options=request_options
        )
        return _response.data

    async def get_status(
        self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> JobStatusV1Response:
        """
        Get the status of a speech to text translate bulk job V1

        Parameters
        ----------
        job_id : str
            The unique identifier of the job

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        JobStatusV1Response
            Successful Response

        Examples
        --------
        import asyncio

        from sarvamai import AsyncSarvamAI

        client = AsyncSarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )


        async def main() -> None:
            await client.speech_to_text_translate_job.get_status(
                job_id="job_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_status(job_id, request_options=request_options)
        return _response.data

    async def start(
        self,
        job_id: str,
        *,
        ptu_id: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> JobStatusV1Response:
        """
        Start a speech to text translate bulk job V1

        Parameters
        ----------
        job_id : str
            The unique identifier of the job

        ptu_id : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        JobStatusV1Response
            Successful Response

        Examples
        --------
        import asyncio

        from sarvamai import AsyncSarvamAI

        client = AsyncSarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )


        async def main() -> None:
            await client.speech_to_text_translate_job.start(
                job_id="job_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.start(job_id, ptu_id=ptu_id, request_options=request_options)
        return _response.data

    async def get_upload_links(
        self,
        *,
        job_id: str,
        files: typing.Sequence[str],
        ptu_id: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesUploadResponse:
        """
        Start a speech to text bulk job V1

        Parameters
        ----------
        job_id : str

        files : typing.Sequence[str]

        ptu_id : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesUploadResponse
            Successful Response

        Examples
        --------
        import asyncio

        from sarvamai import AsyncSarvamAI

        client = AsyncSarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )


        async def main() -> None:
            await client.speech_to_text_translate_job.get_upload_links(
                job_id="job_id",
                files=["files"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_upload_links(
            job_id=job_id, files=files, ptu_id=ptu_id, request_options=request_options
        )
        return _response.data

    async def get_download_links(
        self,
        *,
        job_id: str,
        files: typing.Sequence[str],
        ptu_id: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesDownloadResponse:
        """
        Start a speech to text bulk job V1

        Parameters
        ----------
        job_id : str

        files : typing.Sequence[str]

        ptu_id : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesDownloadResponse
            Successful Response

        Examples
        --------
        import asyncio

        from sarvamai import AsyncSarvamAI

        client = AsyncSarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )


        async def main() -> None:
            await client.speech_to_text_translate_job.get_download_links(
                job_id="job_id",
                files=["files"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_download_links(
            job_id=job_id, files=files, ptu_id=ptu_id, request_options=request_options
        )
        return _response.data
