# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.speech_sample_rate import SpeechSampleRate
from ..types.text_to_speech_language import TextToSpeechLanguage
from ..types.text_to_speech_model import TextToSpeechModel
from ..types.text_to_speech_output_audio_codec import TextToSpeechOutputAudioCodec
from ..types.text_to_speech_response import TextToSpeechResponse
from ..types.text_to_speech_speaker import TextToSpeechSpeaker
from .raw_client import AsyncRawTextToSpeechClient, RawTextToSpeechClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TextToSpeechClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTextToSpeechClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTextToSpeechClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTextToSpeechClient
        """
        return self._raw_client

    def convert(
        self,
        *,
        text: str,
        target_language_code: TextToSpeechLanguage,
        speaker: typing.Optional[TextToSpeechSpeaker] = OMIT,
        pitch: typing.Optional[float] = OMIT,
        pace: typing.Optional[float] = OMIT,
        loudness: typing.Optional[float] = OMIT,
        speech_sample_rate: typing.Optional[SpeechSampleRate] = OMIT,
        enable_preprocessing: typing.Optional[bool] = OMIT,
        model: typing.Optional[TextToSpeechModel] = OMIT,
        output_audio_codec: typing.Optional[TextToSpeechOutputAudioCodec] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TextToSpeechResponse:
        """
        This is the model to convert text into spoken audio.
        The output is a wave file encoded as a base64 string.

        Parameters
        ----------
        text : str

        target_language_code : TextToSpeechLanguage
            The language of the text is BCP-47 format

        speaker : typing.Optional[TextToSpeechSpeaker]
            The speaker voice to be used for the output audio.

            **Default:** Anushka

            **Model Compatibility (Speakers compatible with respective model):**
            - **bulbul:v2:**
              - Female: Anushka, Manisha, Vidya, Arya
              - Male: Abhilash, Karun, Hitesh

            **Note:** Speaker selection must match the chosen model version.

        pitch : typing.Optional[float]
            Controls the pitch of the audio. Lower values result in a deeper voice, while higher values make it sharper. The suitable range is between -0.75 and 0.75. Default is 0.0.

        pace : typing.Optional[float]
            Controls the speed of the audio. Lower values result in slower speech, while higher values make it faster. The suitable range is between 0.5 and 2.0. Default is 1.0.

        loudness : typing.Optional[float]
            Controls the loudness of the audio. Lower values result in quieter audio, while higher values make it louder. The suitable range is between 0.3 and 3.0. Default is 1.0.

        speech_sample_rate : typing.Optional[SpeechSampleRate]
            Specifies the sample rate of the output audio. Supported values are 8000, 16000, 22050, 24000 Hz. If not provided, the default is 22050 Hz.

        enable_preprocessing : typing.Optional[bool]
             Controls whether normalization of English words and numeric entities (e.g., numbers, dates) is performed. Set to true for better handling of mixed-language text. Default is false.

        model : typing.Optional[TextToSpeechModel]
            Specifies the model to use for text-to-speech conversion. Default is bulbul:v2.

        output_audio_codec : typing.Optional[TextToSpeechOutputAudioCodec]
            Specifies the audio codec for the output audio file. Different codecs offer various compression and quality characteristics.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextToSpeechResponse
            Successful Response

        Examples
        --------
        from sarvamai import SarvamAI

        client = SarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )
        client.text_to_speech.convert(
            text="text",
            target_language_code="bn-IN",
        )
        """
        _response = self._raw_client.convert(
            text=text,
            target_language_code=target_language_code,
            speaker=speaker,
            pitch=pitch,
            pace=pace,
            loudness=loudness,
            speech_sample_rate=speech_sample_rate,
            enable_preprocessing=enable_preprocessing,
            model=model,
            output_audio_codec=output_audio_codec,
            request_options=request_options,
        )
        return _response.data


class AsyncTextToSpeechClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTextToSpeechClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTextToSpeechClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTextToSpeechClient
        """
        return self._raw_client

    async def convert(
        self,
        *,
        text: str,
        target_language_code: TextToSpeechLanguage,
        speaker: typing.Optional[TextToSpeechSpeaker] = OMIT,
        pitch: typing.Optional[float] = OMIT,
        pace: typing.Optional[float] = OMIT,
        loudness: typing.Optional[float] = OMIT,
        speech_sample_rate: typing.Optional[SpeechSampleRate] = OMIT,
        enable_preprocessing: typing.Optional[bool] = OMIT,
        model: typing.Optional[TextToSpeechModel] = OMIT,
        output_audio_codec: typing.Optional[TextToSpeechOutputAudioCodec] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TextToSpeechResponse:
        """
        This is the model to convert text into spoken audio.
        The output is a wave file encoded as a base64 string.

        Parameters
        ----------
        text : str

        target_language_code : TextToSpeechLanguage
            The language of the text is BCP-47 format

        speaker : typing.Optional[TextToSpeechSpeaker]
            The speaker voice to be used for the output audio.

            **Default:** Anushka

            **Model Compatibility (Speakers compatible with respective model):**
            - **bulbul:v2:**
              - Female: Anushka, Manisha, Vidya, Arya
              - Male: Abhilash, Karun, Hitesh

            **Note:** Speaker selection must match the chosen model version.

        pitch : typing.Optional[float]
            Controls the pitch of the audio. Lower values result in a deeper voice, while higher values make it sharper. The suitable range is between -0.75 and 0.75. Default is 0.0.

        pace : typing.Optional[float]
            Controls the speed of the audio. Lower values result in slower speech, while higher values make it faster. The suitable range is between 0.5 and 2.0. Default is 1.0.

        loudness : typing.Optional[float]
            Controls the loudness of the audio. Lower values result in quieter audio, while higher values make it louder. The suitable range is between 0.3 and 3.0. Default is 1.0.

        speech_sample_rate : typing.Optional[SpeechSampleRate]
            Specifies the sample rate of the output audio. Supported values are 8000, 16000, 22050, 24000 Hz. If not provided, the default is 22050 Hz.

        enable_preprocessing : typing.Optional[bool]
             Controls whether normalization of English words and numeric entities (e.g., numbers, dates) is performed. Set to true for better handling of mixed-language text. Default is false.

        model : typing.Optional[TextToSpeechModel]
            Specifies the model to use for text-to-speech conversion. Default is bulbul:v2.

        output_audio_codec : typing.Optional[TextToSpeechOutputAudioCodec]
            Specifies the audio codec for the output audio file. Different codecs offer various compression and quality characteristics.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextToSpeechResponse
            Successful Response

        Examples
        --------
        import asyncio

        from sarvamai import AsyncSarvamAI

        client = AsyncSarvamAI(
            api_subscription_key="YOUR_API_SUBSCRIPTION_KEY",
        )


        async def main() -> None:
            await client.text_to_speech.convert(
                text="text",
                target_language_code="bn-IN",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.convert(
            text=text,
            target_language_code=target_language_code,
            speaker=speaker,
            pitch=pitch,
            pace=pace,
            loudness=loudness,
            speech_sample_rate=speech_sample_rate,
            enable_preprocessing=enable_preprocessing,
            model=model,
            output_audio_codec=output_audio_codec,
            request_options=request_options,
        )
        return _response.data
