# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .configure_connection_data import ConfigureConnectionData


class ConfigureConnection(UniversalBaseModel):
    """
    Configuration message required as the first message after establishing the WebSocket connection.
    This initializes TTS parameters and can be updated at any time during the WebSocket lifecycle
    by sending a new config message. When a config update is sent, any text currently in the buffer
    will be automatically flushed and processed before applying the new configuration.
    """

    type: typing.Literal["config"] = "config"
    data: ConfigureConnectionData

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
