# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .configure_connection_data_output_audio_bitrate import ConfigureConnectionDataOutputAudioBitrate
from .configure_connection_data_output_audio_codec import ConfigureConnectionDataOutputAudioCodec
from .configure_connection_data_speaker import ConfigureConnectionDataSpeaker
from .configure_connection_data_target_language_code import ConfigureConnectionDataTargetLanguageCode


class ConfigureConnectionData(UniversalBaseModel):
    target_language_code: ConfigureConnectionDataTargetLanguageCode = pydantic.Field()
    """
    The language of the text is BCP-47 format
    """

    speaker: ConfigureConnectionDataSpeaker = pydantic.Field()
    """
    The speaker voice to be used for the output audio.
    
    **Default:** Anushka
    
    **Model Compatibility (Speakers compatible with respective model):**
    - **bulbul:v2:**
      - Female: Anushka, Manisha, Vidya, Arya
      - Male: Abhilash, Karun, Hitesh
    
    **Note:** Speaker selection must match the chosen model version.
    """

    pitch: typing.Optional[float] = pydantic.Field(default=None)
    """
    Controls the pitch of the audio. Lower values result in a deeper voice, 
    while higher values make it sharper. The suitable range is between -0.75 
    and 0.75. Default is 0.0.
    """

    pace: typing.Optional[float] = pydantic.Field(default=None)
    """
    Controls the speed of the audio. Lower values result in slower speech, 
    while higher values make it faster. The suitable range is between 0.5 
    and 2.0. Default is 1.0.
    """

    loudness: typing.Optional[float] = pydantic.Field(default=None)
    """
    Controls the loudness of the audio. Lower values result in quieter audio, 
    while higher values make it louder. The suitable range is between 0.3 
    and 3.0. Default is 1.0.
    """

    speech_sample_rate: typing.Optional[int] = pydantic.Field(default=None)
    """
    Specifies the sample rate of the output audio. Supported values are 
    8000, 16000, 22050, 24000 Hz. If not provided, the default is 22050 Hz.
    """

    enable_preprocessing: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Controls whether normalization of English words and numeric entities 
    (e.g., numbers, dates) is performed. Set to true for better handling 
    of mixed-language text. Default is false.
    """

    output_audio_codec: typing.Optional[ConfigureConnectionDataOutputAudioCodec] = pydantic.Field(default=None)
    """
    Audio codec (currently supports MP3 only, optimized for real-time playback)
    """

    output_audio_bitrate: typing.Optional[ConfigureConnectionDataOutputAudioBitrate] = pydantic.Field(default=None)
    """
    Audio bitrate (choose from 5 supported bitrate options)
    """

    min_buffer_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    Minimum character length that triggers buffer flushing for TTS model processing
    """

    max_chunk_length: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum length for sentence splitting (adjust based on content length)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
