# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .choice import Choice
from .completion_usage import CompletionUsage


class CreateChatCompletionResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    A unique identifier for the chat completion.
    """

    choices: typing.List[Choice] = pydantic.Field()
    """
    A list of chat completion choices. Can be more than one if `n` is greater than 1.
    """

    created: int = pydantic.Field()
    """
    The Unix timestamp (in seconds) of when the chat completion was created.
    """

    model: str = pydantic.Field()
    """
    The model used for the chat completion.
    """

    object: typing.Literal["chat.completion"] = pydantic.Field(default="chat.completion")
    """
    The object type, which is always `chat.completion`.
    """

    usage: typing.Optional[CompletionUsage] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
