# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .error_code import ErrorCode


class ErrorDetails(UniversalBaseModel):
    message: str = pydantic.Field()
    """
    Message describing the error
    """

    code: ErrorCode = pydantic.Field()
    """
    Error code for the specific error that has occured. Refer to the error code documentation for more details.
    """

    request_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the request. Format: date_UUID4
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
