# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .speech_to_text_model import SpeechToTextModel
from .speech_to_text_translate_language import SpeechToTextTranslateLanguage


class SpeechToTextJobParameters(UniversalBaseModel):
    language_code: typing.Optional[SpeechToTextTranslateLanguage] = pydantic.Field(default=None)
    """
    Language code
    """

    model: typing.Optional[SpeechToTextModel] = pydantic.Field(default=None)
    """
    Model to be used for speech to text
    """

    with_timestamps: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to include timestamps in the response
    """

    with_diarization: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables speaker diarization, which identifies and separates different speakers in the audio. In beta mode
    """

    num_speakers: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of speakers to be detected in the audio. This is used when with_diarization is true.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
