# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .transcription_metrics import TranscriptionMetrics


class SpeechToTextTranscriptionData(UniversalBaseModel):
    request_id: str = pydantic.Field()
    """
    Unique identifier for the request
    """

    transcript: str = pydantic.Field()
    """
    Transcript of the provided speech in original language
    """

    timestamps: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Timestamp information (if available)
    """

    diarized_transcript: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Diarized transcript of the provided speech
    """

    language_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    BCP-47 code of detected language
    """

    metrics: TranscriptionMetrics

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
