# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .speech_to_text_translate_model import SpeechToTextTranslateModel


class SpeechToTextTranslateJobParameters(UniversalBaseModel):
    prompt: typing.Optional[str] = pydantic.Field(default=None)
    """
    Prompt to assist the transcription
    """

    model: typing.Optional[SpeechToTextTranslateModel] = pydantic.Field(default=None)
    """
    Model to be used for converting speech to text in target language
    """

    with_diarization: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables speaker diarization, which identifies and separates different speakers in the audio.
     When set to true, the API will provide speaker-specific segments in the response.
     Note: This parameter is currently in Beta mode.
    """

    num_speakers: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of speakers to be detected in the audio. This is used when with_diarization is set to true.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
