# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .transcription_metrics import TranscriptionMetrics


class SpeechToTextTranslateTranscriptionData(UniversalBaseModel):
    request_id: str = pydantic.Field()
    """
    Unique identifier for the request
    """

    transcript: str = pydantic.Field()
    """
    English translation of the provided speech
    """

    language_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    BCP-47 code of detected source language (null when language detection is in progress)
    """

    metrics: TranscriptionMetrics

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
