# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .content import Content


class GeneralAgentResponseMessageKwargs(UniversalBaseModel):
    """
    Structured kwargs data for response messages with basic required fields.
    """

    additional_kwargs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional keyword arguments for the message.
    """

    content: typing.Optional[Content] = pydantic.Field(default=None)
    """
    The content of the response message, matches main response content.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the message.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name associated with the message.
    """

    response_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Metadata about the response generation.
    """

    role: typing.Optional[str] = pydantic.Field(default=None)
    """
    Role of the message sender.
    """

    tool_call_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the tool call this message responds to (for tool messages).
    """

    tool_calls: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(
        default=None
    )
    """
    Tool calls made by the message (for AI messages).
    """

    type: str = pydantic.Field()
    """
    The type of the message (e.g., 'human', 'ai', 'system', 'tool').
    """

    usage_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Usage metadata including token counts.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
