/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.util.List;

public class TauP_Peek {
    TauModel tMod;

    public void readTauModel(String filename) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        this.tMod = TauModel.readModel(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        String modelFilename = args.length == 2 && (args[0].equals("-mod") || args[0].equals("-model")) ? args[1] : "iasp91.taup";
        boolean DEBUG = false;
        double depth = 0.0;
        try {
            TauP_Peek peek = new TauP_Peek();
            peek.readTauModel(modelFilename);
            TauModel tModDepth = peek.tMod;
            SeismicPhase sp = new SeismicPhase("S", tModDepth);
            StreamTokenizer tokenIn = new StreamTokenizer(new InputStreamReader(System.in));
            tokenIn.parseNumbers();
            System.out.print("seismic (p)hase or (t)au model or (s)lowness model or (v)elocity model or tau (b)ranch? ");
            int modelType = 116;
            tokenIn.nextToken();
            while (tokenIn.nval != -1.0 && !tokenIn.sval.equalsIgnoreCase("q")) {
                if (tokenIn.sval.equalsIgnoreCase("t")) {
                    modelType = 116;
                } else if (tokenIn.sval.equalsIgnoreCase("b")) {
                    modelType = 98;
                } else if (tokenIn.sval.equalsIgnoreCase("s")) {
                    modelType = 115;
                } else if (tokenIn.sval.equalsIgnoreCase("v")) {
                    modelType = 118;
                } else if (tokenIn.sval.equalsIgnoreCase("p")) {
                    modelType = 112;
                } else if (tokenIn.sval.equalsIgnoreCase("r")) {
                    modelType = 114;
                } else {
                    System.out.println("Unrecognized model type: " + (char)modelType);
                    System.out.println("Using (t)au model.");
                    modelType = 116;
                }
                switch (modelType) {
                    case 82: 
                    case 114: {
                        int i;
                        System.out.println("Enter source depth");
                        tokenIn.nextToken();
                        depth = tokenIn.nval;
                        tModDepth = peek.tMod.depthCorrect(depth);
                        double[] rayParams = tModDepth.getRayParams();
                        for (i = 0; i < rayParams.length; ++i) {
                            System.out.print(rayParams[i] + "  ");
                            if (i % 5 != 0) continue;
                            System.out.println();
                        }
                        modelType = 84;
                        break;
                    }
                    case 84: 
                    case 116: {
                        int i;
                        TauModel cfr_ignored_0 = peek.tMod;
                        System.out.println("spherical=" + peek.tMod.isSpherical() + " sourceDepth=" + peek.tMod.getSourceDepth() + " radiusOfEarth=" + peek.tMod.getRadiusOfEarth() + " DEBUG=" + TauModel.DEBUG + " rayParams.length=" + peek.tMod.rayParams.length + " tauBranches[0].length=" + peek.tMod.tauBranches[0].length + " tauBranches[1].length=" + peek.tMod.tauBranches[1].length);
                        for (i = 0; i < peek.tMod.getNumBranches(); ++i) {
                            System.out.println("peek.tMod.tauBranches[0][" + i + "].dist.length=" + peek.tMod.tauBranches[0][i].dist.length + " peek.tMod.tauBranches[1][" + i + "].dist.length=" + peek.tMod.tauBranches[1][i].dist.length);
                        }
                        System.out.println("Enter source depth");
                        tokenIn.nextToken();
                        depth = tokenIn.nval;
                        tModDepth = peek.tMod.depthCorrect(depth);
                        System.out.println("Enter branch rayNum");
                        break;
                    }
                    case 83: 
                    case 115: {
                        System.out.println(peek.tMod.getSlownessModel());
                        System.out.println("Enter slowness layer");
                        break;
                    }
                    case 86: 
                    case 118: {
                        System.out.println(peek.tMod.getVelocityModel());
                        System.out.println("Enter velocity layer");
                        break;
                    }
                    case 80: 
                    case 112: {
                        System.out.println("Enter depth");
                        tokenIn.nextToken();
                        depth = tokenIn.nval;
                        tModDepth = peek.tMod.depthCorrect(depth);
                        System.out.println("Enter phase name");
                        tokenIn.nextToken();
                        sp = new SeismicPhase(tokenIn.sval, tModDepth);
                        System.out.println("Enter degrees");
                        break;
                    }
                    case 66: 
                    case 98: {
                        System.out.println("Enter source depth");
                        tokenIn.nextToken();
                        depth = tokenIn.nval;
                        tModDepth = peek.tMod.depthCorrect(depth);
                        System.out.println("Enter Branch");
                        break;
                    }
                    default: {
                        System.out.println("Unrecognized model type: " + (char)modelType);
                        System.out.println("Using (t)au model.");
                        modelType = 116;
                    }
                }
                tokenIn.nextToken();
                while (tokenIn.ttype == -2) {
                    switch (modelType) {
                        case 84: 
                        case 116: {
                            int branch = (int)tokenIn.nval;
                            tokenIn.nextToken();
                            int rayNum = (int)tokenIn.nval;
                            if (branch >= tModDepth.getNumBranches() || rayNum >= tModDepth.rayParams.length) {
                                System.out.println("Out of bounds!");
                            } else {
                                System.out.println("ray parameter=" + tModDepth.rayParams[rayNum] + " distance=" + tModDepth.tauBranches[0][branch].getDist(rayNum) + " time=" + tModDepth.tauBranches[0][branch].time[rayNum] + " tau=" + tModDepth.tauBranches[0][branch].tau[rayNum]);
                                System.out.println("ray parameter=" + tModDepth.rayParams[rayNum] + " distance=" + tModDepth.tauBranches[1][branch].getDist(rayNum) + " time=" + tModDepth.tauBranches[1][branch].time[rayNum] + " tau=" + tModDepth.tauBranches[1][branch].tau[rayNum]);
                            }
                            System.out.println("Enter branch rayNum");
                            break;
                        }
                        case 83: 
                        case 115: {
                            int layer = (int)tokenIn.nval;
                            if (layer >= peek.tMod.getSlownessModel().getNumLayers(true)) {
                                System.out.println("P wave Out of bounds!");
                            } else {
                                System.out.println(peek.tMod.getSlownessModel().getSlownessLayer(layer, true));
                            }
                            if (layer >= peek.tMod.getSlownessModel().getNumLayers(false)) {
                                System.out.println("S wave Out of bounds!");
                            } else {
                                System.out.println(peek.tMod.getSlownessModel().getSlownessLayer(layer, false));
                            }
                            System.out.println("Enter slowness layer");
                            break;
                        }
                        case 66: 
                        case 98: {
                            int branch = (int)tokenIn.nval;
                            if (branch >= tModDepth.getNumBranches()) {
                                System.out.println("Out of bounds!");
                            } else {
                                System.out.println(tModDepth.tauBranches[0][branch]);
                                System.out.println(tModDepth.tauBranches[1][branch]);
                            }
                            System.out.println("Enter Branch");
                            break;
                        }
                        case 86: 
                        case 118: {
                            int layer = (int)tokenIn.nval;
                            if (layer >= peek.tMod.getSlownessModel().vMod.getNumLayers()) {
                                System.out.println("Out of bounds!");
                            } else {
                                System.out.println(peek.tMod.getSlownessModel().vMod.getVelocityLayer(layer));
                            }
                            System.out.println("Enter velocity layer");
                            break;
                        }
                        case 80: 
                        case 112: {
                            List<Arrival> arr = sp.calcTime(tokenIn.nval);
                            System.out.println("MaxRayParamIndex=" + sp.getMaxRayParamIndex() + " MinRayParamIndex=" + sp.getMinRayParamIndex());
                            for (Arrival arrival : arr) {
                                System.out.println(arrival);
                            }
                            System.out.println("Enter degrees");
                        }
                    }
                    tokenIn.nextToken();
                }
                System.out.print("(t)au model or (s)lowness model or (v)elocity model? ");
                tokenIn.nextToken();
            }
        }
        catch (TauModelException e) {
            System.out.println("Caught TauModelException " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Tried to read!\n Caught IOException " + e.getMessage());
        }
        finally {
            System.out.println("Done!\n");
        }
    }
}

