/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_PhaseDescribe;
import edu.sc.seis.TauP.TauP_SlownessPlot;
import edu.sc.seis.TauP.TauP_VelocityMerge;
import edu.sc.seis.TauP.TauP_VelocityPlot;
import edu.sc.seis.TauP.ToolRun;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;

public abstract class TauP_Tool {
    public static boolean DEBUG = ToolRun.DEBUG;
    public boolean verbose = ToolRun.VERBOSE;
    public String outputFormat = "text";
    protected String outFileBase = "";
    public static final String GMT = "gmt";
    public static final String SVG = "svg";
    public static final String JSON = "json";
    public static final String TEXT = "text";
    public static boolean expert = false;
    protected PrintWriter writer;
    protected Properties toolProps;
    protected Outputs outForms;
    private String outFileExtension = "gmt";

    protected TauP_Tool() {
        try {
            this.toolProps = PropertyLoader.load();
        }
        catch (Exception e) {
            Alert.warning("Unable to load properties, using defaults.", e.getMessage());
            this.toolProps = new Properties();
        }
        Outputs.configure(this.toolProps);
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String val) {
        this.outputFormat = val;
    }

    public String getOutFileBase() {
        return this.outFileBase;
    }

    public void setOutFileBase(String outFileBase) {
        this.outFileBase = outFileBase;
    }

    public String getOutFileExtension() {
        return this.outFileExtension;
    }

    public void setOutFileExtension(String outFileExtension) {
        this.outFileExtension = outFileExtension;
    }

    public String getOutFile() {
        if (this.getOutFileBase() == null || this.getOutFileBase().length() == 0 || this.getOutFileBase().equals("stdout")) {
            return "stdout";
        }
        if (this.getOutFileExtension() == null || this.getOutFileExtension().length() == 0 || this.getOutFileBase().endsWith("." + this.getOutFileExtension())) {
            return this.getOutFileBase();
        }
        return this.getOutFileBase() + "." + this.getOutFileExtension();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = !this.getOutFile().equals("stdout") ? new PrintWriter(new BufferedWriter(new FileWriter(this.getOutFile()))) : new PrintWriter(new OutputStreamWriter(System.out));
            this.printScriptBeginning(this.writer);
        }
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void printScriptBeginning(PrintWriter out) throws IOException {
    }

    public void endGmtAndCleanUp(PrintWriter out, String psFile, String projectionType) {
        out.println("# end postscript");
        out.println("gmt psxy -J" + projectionType + " -R -m -O -T  >> " + psFile);
        out.println("# convert ps to pdf, clean up .ps file");
        out.println("gmt psconvert -P -Tf  " + psFile + " && rm " + psFile);
        out.println("# clean up after gmt...");
        out.println("rm gmt.history");
    }

    public static boolean dashEquals(String argName, String arg) {
        return ToolRun.dashEquals(argName, arg);
    }

    protected abstract String[] parseCmdLineArgs(String[] var1) throws IOException;

    public abstract void init() throws TauPException;

    public abstract void start() throws IOException, TauModelException, TauPException;

    public abstract void destroy() throws TauPException;

    public abstract void printUsage();

    protected String[] parseCommonCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = ToolRun.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_Tool.dashEquals("version", args[i])) {
                Alert.info(BuildVersion.getDetailedVersion());
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            if (TauP_Tool.dashEquals("help", args[i])) {
                this.printUsage();
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            if (TauP_Tool.dashEquals("expert", args[i])) {
                expert = true;
                continue;
            }
            if (i < args.length - 1) {
                if (args[i].equalsIgnoreCase("-o")) {
                    this.outFileBase = args[i + 1];
                    ++i;
                    continue;
                }
                if (TauP_Tool.dashEquals("prop", args[i])) {
                    File f = new File(args[i + 1]);
                    if (!f.exists()) {
                        throw new FileNotFoundException(args[i + 1]);
                    }
                    BufferedReader r = new BufferedReader(new FileReader(args[i + 1]));
                    this.toolProps.load(r);
                    Outputs.configure(this.toolProps);
                    ++i;
                    continue;
                }
                if (i < args.length - 2) {
                    if (args[i].contains("set") && args[i + 1].startsWith("taup.")) {
                        this.toolProps.setProperty(args[i + 1], args[i + 2]);
                        Outputs.configure(this.toolProps);
                        i += 2;
                        continue;
                    }
                    noComprendoArgs[numNoComprendoArgs++] = args[i];
                    continue;
                }
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static String toolNameFromClass(Class toolClass) {
        String className = toolClass.getName();
        String toolName = className = className.substring(className.lastIndexOf(46) + 1, className.length());
        if (toolName.startsWith("TauP_")) {
            toolName = toolName.replace('_', ' ');
        }
        if (toolClass.equals(TauP_VelocityPlot.class)) {
            toolName = "taup velplot";
        } else if (toolClass.equals(TauP_SlownessPlot.class)) {
            toolName = "taup slowplot";
        } else if (toolClass.equals(TauP_VelocityMerge.class)) {
            toolName = "taup velmerge";
        } else if (toolClass.equals(TauP_PhaseDescribe.class)) {
            toolName = "taup phase";
        }
        return toolName.toLowerCase();
    }

    public static void printStdUsageHead(Class toolClass) {
        String toolName = TauP_Tool.toolNameFromClass(toolClass);
        Alert.info("Usage: " + toolName + " [arguments]");
        Alert.info("  or, for purists, java " + toolClass.getName() + " [arguments]");
        Alert.info("\nArguments are:");
    }

    public static void printStdUsageTail() {
        Alert.info("\n-o [stdout|outfile]         -- output is redirected to stdout or to the \"outfile\" file\n--prop [propfile]   -- set configuration properties\n--debug             -- enable debugging output\n--verbose           -- enable verbose output\n--version           -- print the version\n--help              -- print this out, but you already know that!\n");
    }

    public static void printNoComprendoArgs(String[] noComprendoArgs) {
        if (noComprendoArgs.length > 0) {
            for (int i = 0; i < noComprendoArgs.length; ++i) {
                if (!TauP_Tool.dashEquals("help", noComprendoArgs[i]) && !TauP_Tool.dashEquals("version", noComprendoArgs[i])) continue;
                return;
            }
            String outStringA = "I don't understand the following arguments, continuing:";
            String outStringB = "";
            for (int i = 0; i < noComprendoArgs.length; ++i) {
                outStringB = outStringB + noComprendoArgs[i] + " ";
            }
            Alert.warning(outStringA, outStringB);
            noComprendoArgs = null;
        }
    }
}

