/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class TauP_VelocityMerge
extends TauP_Tool {
    String modelName;
    String modelType;
    String overlayModelName = null;
    String overlayModelType = null;
    boolean smoothTop = false;
    boolean smoothBottom = false;

    public TauP_VelocityMerge() {
        this.setOutputFormat("nd");
        this.setOutFileExtension("nd");
        this.setOutFileBase("velmerge");
    }

    @Override
    public void start() throws SlownessModelException, TauModelException, VelocityModelException, IOException {
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelName + ", tried internally and from file");
        }
        this.setOutFileBase(vMod.modelName);
        VelocityModel outVMod = vMod;
        if (this.overlayModelName != null) {
            if (DEBUG) {
                System.out.println("base model: " + vMod.modelName);
                System.out.println("merge model: " + this.overlayModelName);
            }
            VelocityModel overlayVMod = TauModelLoader.loadVelocityModel(this.overlayModelName, this.overlayModelType);
            outVMod = vMod.replaceLayers(overlayVMod.getLayers(), overlayVMod.getModelName(), this.smoothTop, this.smoothBottom);
            outVMod.setModelName(vMod.modelName + "_" + overlayVMod.getModelName());
            this.setOutFileBase(outVMod.modelName);
        }
        try {
            PrintWriter dos = this.getOutFile() == "stdout" ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter(new BufferedWriter(new FileWriter(this.getOutFile())));
            outVMod.writeToND(dos);
            dos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = super.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_VelocityMerge.dashEquals("smtop", args[i])) {
                this.smoothTop = true;
                continue;
            }
            if (TauP_VelocityMerge.dashEquals("smbot", args[i])) {
                this.smoothBottom = true;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals("nd", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "nd";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals("tvel", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "tvel";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals("mod", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = null;
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals("ndmerge", args[i])) {
                this.overlayModelName = args[i + 1];
                this.overlayModelType = "nd";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals("tvelmerge", args[i])) {
                this.overlayModelName = args[i + 1];
                this.overlayModelType = "tvel";
                ++i;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void printUsage() {
        TauP_Tool.printStdUsageHead(this.getClass());
        System.out.println("-mod[el] modelname -- base velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n");
        System.out.println("-nd modelfile       -- base \"named discontinuities\" velocity file");
        System.out.println("-tvel modelfile     -- base \".tvel\" velocity file, ala ttimes\n");
        System.out.println("-ndmerge modelfile       -- \"named discontinuities\" velocity file to merge");
        System.out.println("-tvelmerge modelfile     -- \".tvel\" velocity file to merge, ala ttimes\n");
        System.out.println("-smtop              -- smooth merge at top\n");
        System.out.println("-smbot              -- smooth merge at bottom\n");
        TauP_Tool.printStdUsageTail();
    }
}

