/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.IOException;

public class TauP_VelocityPlot
extends TauP_Tool {
    public static final String DEFAULT_OUTFILE = "taup_velocitymodel";
    String modelName;
    String modelType;
    String overlayModelName = null;
    String overlayModelType = null;

    public TauP_VelocityPlot() {
        this.setOutFileBase(DEFAULT_OUTFILE);
    }

    @Override
    public void start() throws SlownessModelException, TauModelException, VelocityModelException, IOException {
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelName + ", tried internally and from file");
        }
        if (this.getOutFileBase() == DEFAULT_OUTFILE) {
            this.setOutFileBase(vMod.modelName + "_vel");
        }
        vMod.printGMT(this.getOutFile());
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = super.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("nd", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "nd";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("tvel", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "tvel";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("mod", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = null;
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("overlay", args[i])) {
                this.overlayModelName = args[i + 1];
                ++i;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void printUsage() {
        TauP_Tool.printStdUsageHead(this.getClass());
        System.out.println("-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n");
        System.out.println("-nd modelfile       -- \"named discontinuities\" velocity file");
        System.out.println("-tvel modelfile     -- \".tvel\" velocity file, ala ttimes\n");
        TauP_Tool.printStdUsageTail();
    }
}

