s = """#===============================================================================
# This is the input file of FORTRAN77 program "edcomp" for calculating
# earthquakes' static deformations (3 displacement components, 6 strain/stress
# components and 2 vertical tilt components) based on the dislocation theory.
# The earth model used is either a homogeneous or multi-layered, isotropic and
# elastic half-space. The earthquke source is represented by an arbitrary number
# of rectangular dislocation planes.
#
# Note that the Cartesian coordinate system is used and the seismological
# convention is adopted, that is, x is northward, y is eastward, and z is
# downward.
#
# First implemented in Potsdam, Feb, 1999
# Last modified: Potsdam, Nov, 2001
#
# by
# Rongjiang Wang, Frank Roth, & Francisco Lorenzo
# GeoForschungsZentrum Potsdam, Telegrafenberg, 14473 Potsdam, Germany
#
# For questions and suggestions please send e-mails to wang@gfz-potsdam.de
#===============================================================================
# OBSERVATION ARRAY
# =================
# 1. switch for irregular positions (0) or a 1D profile (1)
#    or a rectangular 2D observation array (2): ixyr
#
#    IF (the switch = 0 for irregular observation positions) THEN
#    
# 2. number of positions: nr
# 3. coordinates of the observations: (xr(i),yr(i)),i=1,nr
#
#    ELSE IF (the switch = 1 for a 1D profile) THEN
#
# 2. number of position samples of the profile: nr
# 3. the start and end positions: (xr1,yr1), (xr2,yr2)
#
#    ELSE IF (the switch = 2 for rectanglular 2D observation array) THEN
#
# 2. number of xr samples, start and end values [m]: nxr, xr1,xr2
# 3. number of yr samples, start and end values [m]: nyr, yr1,yr2
#
#    Note that the total number of observation positions (nr or nxr*nyr)
#    should be <= NRECMAX (see edcglobal.h)!
#===============================================================================
2
51  -35.00d+03   15.00d+03
51  -25.00d+03   25.00d+03
#===============================================================================
# OUTPUTS
# =======
# 1. output directory in char format: outdir
# 2. select the desired outputs (1/0 = yes/no)
# 3. the file names in char format for displacement vector, strain tensor,
#    stress tensor, vertical tilts, and los:
#    dispfile, strainfile, stressfile, tiltfile, losfile
#
#    Note that all file or directory names should not be longer than 80
#    characters. Directories must be ended by (unix) or (dos)!
#===============================================================================
''
0          0          1           0
'hs.disp'  'hs.strain'  'hs.stress'  'hs.tilt'
#===============================================================================
# RECTANGLAR DISLOCATION SOURCES
# ==============================
# 1. number of the source rectangles: ns (<= NSMAX in edcglobal.h)
# 2. the 6 parameters for the 1. source rectangle:
#    Slip [m],
#    coordinates of the upper reference point for strike (xs, ys, zs) [m],
#    length (strike direction) [m], and width (dip direction) [m],
#    strike [deg], dip [deg], and rake [deg];
# 3. ... for the 2. source ...
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#    Note that if one of the parameters length and width = 0, then a line source
#    will be considered and the dislocation parameter Slip has the unit m^2; if
#    both length and width = 0, then a point source will be considered and the
#    Slip has the unit m^3.
#===============================================================================
1
#         coord. origin:
#-------------------------------------------------------------------------------
# no  Slip   xs        ys       zs        length    width   strike   dip  rake
#-------------------------------------------------------------------------------
1  2.50 0.0d+00  0.0d+00  0.2d+03   11.d+03  10.0d+03   174.0  88.0  178.0
#===============================================================================
# If the earth model used is a layered half-space, then the numerical Green's
# function approach is applied. The Green's functions should have been prepared
# with the program "edgrn" before the program "edcmp" is started. In this case,
# the following input data give the addresses where the Green's functions have
# been stored and the grid side to be used for the automatic discretization
# of the finite rectangular sources.
#
# If the earth model used is a homogeneous half-space, then the analytical
# method of Okada (1992) is applied. In this case, the Green's functions are
# not needed, and the following input data give the shear modulus and the
# Poisson ratio of the model.
#===============================================================================
# CHOICE OF EARTH MODEL
# =====================
# 1. switch for layered (1) or homogeneous (0) model
#
#    IF (layered model) THEN
#
# 2. directory of the Green's functions and the three files for the
#    fundamental Green's functions: grndir, grnfiles(3);
#
#    Note that all file or directory names should not be longer than 80
#    characters. Directories must be ended by (unix) or (dos)!
#
#    ELSE (homogeneous model) THEN
#
# 2. the observation depth, the two Lame constants parameters of the homogeneous
#    model: zrec [m], lambda [Pa], mu [Pa]
#===============================================================================
#  1
#  ''  'edgrnhs.ss'  'edgrnhs.ds'  'edgrnhs.cl'
0
0.00d+00  30516224000  33701888000
#================================end of input==================================="""
