# AbsBox 
a structured finance cashflow engine wrapper for structured credit professionals:

* transparency -> open source for both wrapper and backend engine
* human readable waterfall -> no more coding/scripting, just list and maps in Python !
* easy interaction with Python numeric libraries as well as databases/Excel to accomodate daily work.

[![Python version](https://img.shields.io/pypi/pyversions/absbox)](https://img.shields.io/pypi/pyversions/absbox)
[![PyPI version](https://badge.fury.io/py/absbox.svg)](https://badge.fury.io/py/absbox)
[![PyPI download](https://img.shields.io/pypi/dm/absbox)](https://img.shields.io/pypi/dm/absbox)

## installation

    pip install absbox

## Community & Support

* [Discussion](https://github.com/yellowbean/AbsBox/discussions)

## Goals
* Provide building blocks to create cashflow models for ABS/MBS
* Adapt to multiple asset classes
    * Residential Mortgage / Auto Loans
    * Corp Loans
    * Consumer Credit
    * Lease
* Features
  * Sensitivity Analysis on different scenarios or deal structures
    * sensitiviy analysis on pool performance assumptions
    * sensitiviy analysis on capital structures or any deal components
  * Bond Cashflow/Pool Cashflow Forecast, Pricing

## Data flow

![image](https://user-images.githubusercontent.com/1008321/221366747-5e37fc9e-dfaa-44b5-ab00-f5c8a3b26d79.png)


## Documentation
* English -> https://absbox-doc.readthedocs.io
* Chinese -> https://absbox.readthedocs.io
