from typing import Dict, Optional, Sequence, Union

from weaviate.collections.tenants.types import (
    TenantCreateInputType,
    TenantInputType,
    TenantOutputType,
    TenantUpdateInputType,
)
from weaviate.connect.v4 import ConnectionSync

from .executor import _TenantsExecutor

class _Tenants(_TenantsExecutor[ConnectionSync]):
    def create(
        self, tenants: Union[TenantCreateInputType, Sequence[TenantCreateInputType]]
    ) -> None: ...
    def remove(self, tenants: Union[TenantInputType, Sequence[TenantInputType]]) -> None: ...
    def get(self) -> Dict[str, TenantOutputType]: ...
    def get_by_names(self, tenants: Sequence[TenantInputType]) -> Dict[str, TenantOutputType]: ...
    def get_by_name(self, tenant: TenantInputType) -> Optional[TenantOutputType]: ...
    def update(
        self, tenants: Union[TenantUpdateInputType, Sequence[TenantUpdateInputType]]
    ) -> None: ...
    def exists(self, tenant: TenantInputType) -> bool: ...
    def activate(self, tenant: Union[TenantInputType, Sequence[TenantInputType]]) -> None: ...
    def deactivate(self, tenant: Union[TenantInputType, Sequence[TenantInputType]]) -> None: ...
    def offload(self, tenant: Union[TenantInputType, Sequence[TenantInputType]]) -> None: ...
