# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ContentV1DatasourcePresetSummary(BaseModel):
    """
    ContentV1DatasourcePresetSummary
    """ # noqa: E501
    bronze_event_expr: Optional[StrictStr] = Field(default=None, description="The Spark SQL expression used to determine a row's event class.")
    silver_table_event_mappings: Optional[Dict[str, StrictStr]] = Field(default=None, description="A mapping of which event classes maps to which silver tables.")
    gold_table_event_mappings: Optional[Dict[str, StrictStr]] = Field(default=None, description="A mapping of which event classes maps to which gold tables.")
    __properties: ClassVar[List[str]] = ["bronze_event_expr", "silver_table_event_mappings", "gold_table_event_mappings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if bronze_event_expr (nullable) is None
        # and model_fields_set contains the field
        if self.bronze_event_expr is None and "bronze_event_expr" in self.model_fields_set:
            _dict['bronze_event_expr'] = None

        # set to None if silver_table_event_mappings (nullable) is None
        # and model_fields_set contains the field
        if self.silver_table_event_mappings is None and "silver_table_event_mappings" in self.model_fields_set:
            _dict['silver_table_event_mappings'] = None

        # set to None if gold_table_event_mappings (nullable) is None
        # and model_fields_set contains the field
        if self.gold_table_event_mappings is None and "gold_table_event_mappings" in self.model_fields_set:
            _dict['gold_table_event_mappings'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bronze_event_expr": obj.get("bronze_event_expr"),
            "silver_table_event_mappings": obj.get("silver_table_event_mappings"),
            "gold_table_event_mappings": obj.get("gold_table_event_mappings")
        })
        return _obj


