# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.content_v1_datasource_preset_autoloader_cloud_files import ContentV1DatasourcePresetAutoloaderCloudFiles
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceAutoloaderSpec(BaseModel):
    """
    CoreV1DataSourceAutoloaderSpec
    """ # noqa: E501
    format: Optional[StrictStr] = Field(default=None, description="json | jsonl | parquet | csv | text | wholetext")
    location: StrictStr = Field(description="External location for a volume in Unity Catalog (anything you can pass to autoloader is here).")
    schema_file: Optional[StrictStr] = Field(default=None, description="An optional file containing the schema of the data source.", alias="schemaFile")
    var_schema: Optional[StrictStr] = Field(default=None, description="An optional string representing the schema of the data source.", alias="schema")
    cloud_files: Optional[ContentV1DatasourcePresetAutoloaderCloudFiles] = Field(default=None, alias="cloudFiles")
    __properties: ClassVar[List[str]] = ["format", "location", "schemaFile", "schema", "cloudFiles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceAutoloaderSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cloud_files
        if self.cloud_files:
            _dict['cloudFiles'] = self.cloud_files.to_dict()
        # set to None if format (nullable) is None
        # and model_fields_set contains the field
        if self.format is None and "format" in self.model_fields_set:
            _dict['format'] = None

        # set to None if schema_file (nullable) is None
        # and model_fields_set contains the field
        if self.schema_file is None and "schema_file" in self.model_fields_set:
            _dict['schemaFile'] = None

        # set to None if var_schema (nullable) is None
        # and model_fields_set contains the field
        if self.var_schema is None and "var_schema" in self.model_fields_set:
            _dict['schema'] = None

        # set to None if cloud_files (nullable) is None
        # and model_fields_set contains the field
        if self.cloud_files is None and "cloud_files" in self.model_fields_set:
            _dict['cloudFiles'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceAutoloaderSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "format": obj.get("format"),
            "location": obj.get("location"),
            "schemaFile": obj.get("schemaFile"),
            "schema": obj.get("schema"),
            "cloudFiles": ContentV1DatasourcePresetAutoloaderCloudFiles.from_dict(obj["cloudFiles"]) if obj.get("cloudFiles") is not None else None
        })
        return _obj


