# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_spec_gold_preset_overrides_add_tables_inner import CoreV1DataSourceSpecGoldPresetOverridesAddTablesInner
from dasl_api.models.core_v1_data_source_spec_gold_preset_overrides_modify_tables_inner import CoreV1DataSourceSpecGoldPresetOverridesModifyTablesInner
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpecGoldPresetOverrides(BaseModel):
    """
    CoreV1DataSourceSpecGoldPresetOverrides
    """ # noqa: E501
    omit_tables: Optional[List[StrictStr]] = Field(default=None, alias="omitTables")
    modify_tables: Optional[List[CoreV1DataSourceSpecGoldPresetOverridesModifyTablesInner]] = Field(default=None, alias="modifyTables")
    add_tables: Optional[List[CoreV1DataSourceSpecGoldPresetOverridesAddTablesInner]] = Field(default=None, alias="addTables")
    __properties: ClassVar[List[str]] = ["omitTables", "modifyTables", "addTables"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecGoldPresetOverrides from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in modify_tables (list)
        _items = []
        if self.modify_tables:
            for _item_modify_tables in self.modify_tables:
                if _item_modify_tables:
                    _items.append(_item_modify_tables.to_dict())
            _dict['modifyTables'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in add_tables (list)
        _items = []
        if self.add_tables:
            for _item_add_tables in self.add_tables:
                if _item_add_tables:
                    _items.append(_item_add_tables.to_dict())
            _dict['addTables'] = _items
        # set to None if omit_tables (nullable) is None
        # and model_fields_set contains the field
        if self.omit_tables is None and "omit_tables" in self.model_fields_set:
            _dict['omitTables'] = None

        # set to None if modify_tables (nullable) is None
        # and model_fields_set contains the field
        if self.modify_tables is None and "modify_tables" in self.model_fields_set:
            _dict['modifyTables'] = None

        # set to None if add_tables (nullable) is None
        # and model_fields_set contains the field
        if self.add_tables is None and "add_tables" in self.model_fields_set:
            _dict['addTables'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecGoldPresetOverrides from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "omitTables": obj.get("omitTables"),
            "modifyTables": [CoreV1DataSourceSpecGoldPresetOverridesModifyTablesInner.from_dict(_item) for _item in obj["modifyTables"]] if obj.get("modifyTables") is not None else None,
            "addTables": [CoreV1DataSourceSpecGoldPresetOverridesAddTablesInner.from_dict(_item) for _item in obj["addTables"]] if obj.get("addTables") is not None else None
        })
        return _obj


