# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_field_spec import CoreV1DataSourceFieldSpec
from dasl_api.models.core_v1_data_source_spec_silver_transform_preset_overrides_modify_tables_inner_custom import CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInnerCustom
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpecGoldPresetOverridesModifyTablesInner(BaseModel):
    """
    CoreV1DataSourceSpecGoldPresetOverridesModifyTablesInner
    """ # noqa: E501
    name: Optional[StrictStr] = Field(description="The name of a preset's matching gold stanza to override in conjunction with the sourceTable  field. Multiple writes to the same gold table can exist within a preset and each definition has an `input` field that is used to identify the silver transform data to use as input (i.e., multiple writes to the gold table from different silver tables). The name and sourceTable  are used to match against the preset's name and input table. ")
    source_table: Optional[StrictStr] = Field(description="Used to match against the preset's gold stanzas `input` fields. This is required because the  gold preset name is ambiguous such that you need to distinguish between multiple gold table definitions. ", alias="sourceTable")
    custom: Optional[CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInnerCustom] = None
    omit_fields: Optional[List[StrictStr]] = Field(default=None, description="A list of fields to omit from the corresponding preset definition.", alias="omitFields")
    add_fields: Optional[List[Optional[CoreV1DataSourceFieldSpec]]] = Field(default=None, alias="addFields")
    filter: Optional[StrictStr] = None
    post_filter: Optional[StrictStr] = Field(default=None, alias="postFilter")
    __properties: ClassVar[List[str]] = ["name", "sourceTable", "custom", "omitFields", "addFields", "filter", "postFilter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecGoldPresetOverridesModifyTablesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of custom
        if self.custom:
            _dict['custom'] = self.custom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in add_fields (list)
        _items = []
        if self.add_fields:
            for _item_add_fields in self.add_fields:
                if _item_add_fields:
                    _items.append(_item_add_fields.to_dict())
            _dict['addFields'] = _items
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if source_table (nullable) is None
        # and model_fields_set contains the field
        if self.source_table is None and "source_table" in self.model_fields_set:
            _dict['sourceTable'] = None

        # set to None if custom (nullable) is None
        # and model_fields_set contains the field
        if self.custom is None and "custom" in self.model_fields_set:
            _dict['custom'] = None

        # set to None if omit_fields (nullable) is None
        # and model_fields_set contains the field
        if self.omit_fields is None and "omit_fields" in self.model_fields_set:
            _dict['omitFields'] = None

        # set to None if add_fields (nullable) is None
        # and model_fields_set contains the field
        if self.add_fields is None and "add_fields" in self.model_fields_set:
            _dict['addFields'] = None

        # set to None if filter (nullable) is None
        # and model_fields_set contains the field
        if self.filter is None and "filter" in self.model_fields_set:
            _dict['filter'] = None

        # set to None if post_filter (nullable) is None
        # and model_fields_set contains the field
        if self.post_filter is None and "post_filter" in self.model_fields_set:
            _dict['postFilter'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecGoldPresetOverridesModifyTablesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "sourceTable": obj.get("sourceTable"),
            "custom": CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInnerCustom.from_dict(obj["custom"]) if obj.get("custom") is not None else None,
            "omitFields": obj.get("omitFields"),
            "addFields": [CoreV1DataSourceFieldSpec.from_dict(_item) for _item in obj["addFields"]] if obj.get("addFields") is not None else None,
            "filter": obj.get("filter"),
            "postFilter": obj.get("postFilter")
        })
        return _obj


