# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_spec_silver_bronze_tables_inner_watermark import CoreV1DataSourceSpecSilverBronzeTablesInnerWatermark
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpecSilverBronzeTablesInner(BaseModel):
    """
    CoreV1DataSourceSpecSilverBronzeTablesInner
    """ # noqa: E501
    name: Optional[StrictStr] = None
    streaming: Optional[StrictBool] = Field(default=None, description="for tables other than the first, is this a streaming join or static.")
    watermark: Optional[CoreV1DataSourceSpecSilverBronzeTablesInnerWatermark] = None
    alias: Optional[StrictStr] = Field(default=None, description="Alias name for the table.")
    join_type: Optional[StrictStr] = Field(default=None, description="For tables other than the first, how to join to the preceding table.", alias="joinType")
    join_expr: Optional[StrictStr] = Field(default=None, description="For tables other than the first, the join condition expression to join with the preceding table.", alias="joinExpr")
    __properties: ClassVar[List[str]] = ["name", "streaming", "watermark", "alias", "joinType", "joinExpr"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilverBronzeTablesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of watermark
        if self.watermark:
            _dict['watermark'] = self.watermark.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if streaming (nullable) is None
        # and model_fields_set contains the field
        if self.streaming is None and "streaming" in self.model_fields_set:
            _dict['streaming'] = None

        # set to None if watermark (nullable) is None
        # and model_fields_set contains the field
        if self.watermark is None and "watermark" in self.model_fields_set:
            _dict['watermark'] = None

        # set to None if alias (nullable) is None
        # and model_fields_set contains the field
        if self.alias is None and "alias" in self.model_fields_set:
            _dict['alias'] = None

        # set to None if join_type (nullable) is None
        # and model_fields_set contains the field
        if self.join_type is None and "join_type" in self.model_fields_set:
            _dict['joinType'] = None

        # set to None if join_expr (nullable) is None
        # and model_fields_set contains the field
        if self.join_expr is None and "join_expr" in self.model_fields_set:
            _dict['joinExpr'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilverBronzeTablesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "streaming": obj.get("streaming"),
            "watermark": CoreV1DataSourceSpecSilverBronzeTablesInnerWatermark.from_dict(obj["watermark"]) if obj.get("watermark") is not None else None,
            "alias": obj.get("alias"),
            "joinType": obj.get("joinType"),
            "joinExpr": obj.get("joinExpr")
        })
        return _obj


