# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_post_metrics_request_exec_results_inner import CoreV1PostMetricsRequestExecResultsInner
from typing import Optional, Set
from typing_extensions import Self

class CoreV1PostMetricsRequest(BaseModel):
    """
    CoreV1PostMetricsRequest
    """ # noqa: E501
    job_name: Optional[StrictStr] = Field(default=None, description="The job's name.", alias="jobName")
    job_id: Optional[StrictInt] = Field(default=None, description="The job' ID.", alias="jobId")
    job_type: Optional[StrictStr] = Field(default=None, description="The job's type [datasource | rule | transform].", alias="jobType")
    datasource_source_type: Optional[StrictStr] = Field(default=None, description="The datasource source type.", alias="datasourceSourceType")
    datasource_source: Optional[StrictStr] = Field(default=None, description="The datasource source.", alias="datasourceSource")
    operational_alert_count: Optional[StrictInt] = Field(default=None, description="Number of operational alerts raised during job run.", alias="operationalAlertCount")
    failed_resource_names: Optional[List[StrictStr]] = Field(default=None, description="The resource names that failed their run.", alias="failedResourceNames")
    exec_results: Optional[List[CoreV1PostMetricsRequestExecResultsInner]] = Field(default=None, alias="execResults")
    __properties: ClassVar[List[str]] = ["jobName", "jobId", "jobType", "datasourceSourceType", "datasourceSource", "operationalAlertCount", "failedResourceNames", "execResults"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1PostMetricsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in exec_results (list)
        _items = []
        if self.exec_results:
            for _item_exec_results in self.exec_results:
                if _item_exec_results:
                    _items.append(_item_exec_results.to_dict())
            _dict['execResults'] = _items
        # set to None if job_name (nullable) is None
        # and model_fields_set contains the field
        if self.job_name is None and "job_name" in self.model_fields_set:
            _dict['jobName'] = None

        # set to None if job_id (nullable) is None
        # and model_fields_set contains the field
        if self.job_id is None and "job_id" in self.model_fields_set:
            _dict['jobId'] = None

        # set to None if job_type (nullable) is None
        # and model_fields_set contains the field
        if self.job_type is None and "job_type" in self.model_fields_set:
            _dict['jobType'] = None

        # set to None if datasource_source_type (nullable) is None
        # and model_fields_set contains the field
        if self.datasource_source_type is None and "datasource_source_type" in self.model_fields_set:
            _dict['datasourceSourceType'] = None

        # set to None if datasource_source (nullable) is None
        # and model_fields_set contains the field
        if self.datasource_source is None and "datasource_source" in self.model_fields_set:
            _dict['datasourceSource'] = None

        # set to None if operational_alert_count (nullable) is None
        # and model_fields_set contains the field
        if self.operational_alert_count is None and "operational_alert_count" in self.model_fields_set:
            _dict['operationalAlertCount'] = None

        # set to None if failed_resource_names (nullable) is None
        # and model_fields_set contains the field
        if self.failed_resource_names is None and "failed_resource_names" in self.model_fields_set:
            _dict['failedResourceNames'] = None

        # set to None if exec_results (nullable) is None
        # and model_fields_set contains the field
        if self.exec_results is None and "exec_results" in self.model_fields_set:
            _dict['execResults'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1PostMetricsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "jobName": obj.get("jobName"),
            "jobId": obj.get("jobId"),
            "jobType": obj.get("jobType"),
            "datasourceSourceType": obj.get("datasourceSourceType"),
            "datasourceSource": obj.get("datasourceSource"),
            "operationalAlertCount": obj.get("operationalAlertCount"),
            "failedResourceNames": obj.get("failedResourceNames"),
            "execResults": [CoreV1PostMetricsRequestExecResultsInner.from_dict(_item) for _item in obj["execResults"]] if obj.get("execResults") is not None else None
        })
        return _obj


