# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CoreV1PostMetricsRequestExecResultsInner(BaseModel):
    """
    CoreV1PostMetricsRequestExecResultsInner
    """ # noqa: E501
    resource_name: Optional[StrictStr] = Field(default=None, description="The resource metadata name.", alias="resourceName")
    timestamp: Optional[datetime] = Field(default=None, description="The datasource source type.")
    duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Duration of job in milliseconds.")
    rows_processed: Optional[StrictInt] = Field(default=None, description="Number of rows processed during job run.", alias="rowsProcessed")
    bronze_rows_written: Optional[StrictInt] = Field(default=None, description="Number of rows written to all bronze tables in the datasource.", alias="bronzeRowsWritten")
    silver_rows_written: Optional[StrictInt] = Field(default=None, description="Number of rows written to all silver tables in the datasource.", alias="silverRowsWritten")
    gold_rows_written: Optional[StrictInt] = Field(default=None, description="Number of rows written to all gold tables in the datasource.", alias="goldRowsWritten")
    table_rows_written: Optional[Dict[str, StrictInt]] = Field(default=None, description="Number of rows written to each tables in the datasource.", alias="tableRowsWritten")
    batch_processing_ms: Optional[StrictInt] = Field(default=None, description="Duration in milliseconds spent processing all input batches in the datasource.", alias="batchProcessingMs")
    bronze_batch_processing_ms: Optional[StrictInt] = Field(default=None, description="Duration in milliseconds spent processing all bronze input batches in the datasource.", alias="bronzeBatchProcessingMs")
    silver_batch_processing_ms: Optional[StrictInt] = Field(default=None, description="Duration in milliseconds spent processing all silver input batches in the datasource.", alias="silverBatchProcessingMs")
    gold_batch_processing_ms: Optional[StrictInt] = Field(default=None, description="Duration in milliseconds spent processing all gold input batches in the datasource.", alias="goldBatchProcessingMs")
    table_batch_processing_ms: Optional[Dict[str, StrictInt]] = Field(default=None, description="Duration in milliseconds spent processing input batches for each table in the datasource.", alias="tableBatchProcessingMs")
    __properties: ClassVar[List[str]] = ["resourceName", "timestamp", "duration", "rowsProcessed", "bronzeRowsWritten", "silverRowsWritten", "goldRowsWritten", "tableRowsWritten", "batchProcessingMs", "bronzeBatchProcessingMs", "silverBatchProcessingMs", "goldBatchProcessingMs", "tableBatchProcessingMs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1PostMetricsRequestExecResultsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if resource_name (nullable) is None
        # and model_fields_set contains the field
        if self.resource_name is None and "resource_name" in self.model_fields_set:
            _dict['resourceName'] = None

        # set to None if timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.timestamp is None and "timestamp" in self.model_fields_set:
            _dict['timestamp'] = None

        # set to None if duration (nullable) is None
        # and model_fields_set contains the field
        if self.duration is None and "duration" in self.model_fields_set:
            _dict['duration'] = None

        # set to None if rows_processed (nullable) is None
        # and model_fields_set contains the field
        if self.rows_processed is None and "rows_processed" in self.model_fields_set:
            _dict['rowsProcessed'] = None

        # set to None if bronze_rows_written (nullable) is None
        # and model_fields_set contains the field
        if self.bronze_rows_written is None and "bronze_rows_written" in self.model_fields_set:
            _dict['bronzeRowsWritten'] = None

        # set to None if silver_rows_written (nullable) is None
        # and model_fields_set contains the field
        if self.silver_rows_written is None and "silver_rows_written" in self.model_fields_set:
            _dict['silverRowsWritten'] = None

        # set to None if gold_rows_written (nullable) is None
        # and model_fields_set contains the field
        if self.gold_rows_written is None and "gold_rows_written" in self.model_fields_set:
            _dict['goldRowsWritten'] = None

        # set to None if batch_processing_ms (nullable) is None
        # and model_fields_set contains the field
        if self.batch_processing_ms is None and "batch_processing_ms" in self.model_fields_set:
            _dict['batchProcessingMs'] = None

        # set to None if bronze_batch_processing_ms (nullable) is None
        # and model_fields_set contains the field
        if self.bronze_batch_processing_ms is None and "bronze_batch_processing_ms" in self.model_fields_set:
            _dict['bronzeBatchProcessingMs'] = None

        # set to None if silver_batch_processing_ms (nullable) is None
        # and model_fields_set contains the field
        if self.silver_batch_processing_ms is None and "silver_batch_processing_ms" in self.model_fields_set:
            _dict['silverBatchProcessingMs'] = None

        # set to None if gold_batch_processing_ms (nullable) is None
        # and model_fields_set contains the field
        if self.gold_batch_processing_ms is None and "gold_batch_processing_ms" in self.model_fields_set:
            _dict['goldBatchProcessingMs'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1PostMetricsRequestExecResultsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resourceName": obj.get("resourceName"),
            "timestamp": obj.get("timestamp"),
            "duration": obj.get("duration"),
            "rowsProcessed": obj.get("rowsProcessed"),
            "bronzeRowsWritten": obj.get("bronzeRowsWritten"),
            "silverRowsWritten": obj.get("silverRowsWritten"),
            "goldRowsWritten": obj.get("goldRowsWritten"),
            "tableRowsWritten": obj.get("tableRowsWritten"),
            "batchProcessingMs": obj.get("batchProcessingMs"),
            "bronzeBatchProcessingMs": obj.get("bronzeBatchProcessingMs"),
            "silverBatchProcessingMs": obj.get("silverBatchProcessingMs"),
            "goldBatchProcessingMs": obj.get("goldBatchProcessingMs"),
            "tableBatchProcessingMs": obj.get("tableBatchProcessingMs")
        })
        return _obj


