# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1RuleSpecCollate(BaseModel):
    """
    Current not supported.
    """ # noqa: E501
    collate_on: Optional[List[StrictStr]] = Field(default=None, description="SQL column(s) to collate notables on. This must be either 'summary', 'context', or a JSON key within 'context'. Note that for a context defined as '{\"user\": \"value\"}', collating on the 'user' key of 'context' would follow the syntax \"context:`user`\". Only one level of nesting is currently supported. ", alias="collateOn")
    within: Optional[StrictStr] = Field(default=None, description="A time duration string for the window to collate within.")
    action: Optional[StrictStr] = Field(default=None, description="append | input | output")
    __properties: ClassVar[List[str]] = ["collateOn", "within", "action"]

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['append', 'updateStats', 'inhibit']):
            raise ValueError("must be one of enum values ('append', 'updateStats', 'inhibit')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecCollate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if collate_on (nullable) is None
        # and model_fields_set contains the field
        if self.collate_on is None and "collate_on" in self.model_fields_set:
            _dict['collateOn'] = None

        # set to None if within (nullable) is None
        # and model_fields_set contains the field
        if self.within is None and "within" in self.model_fields_set:
            _dict['within'] = None

        # set to None if action (nullable) is None
        # and model_fields_set contains the field
        if self.action is None and "action" in self.model_fields_set:
            _dict['action'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecCollate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "collateOn": obj.get("collateOn"),
            "within": obj.get("within"),
            "action": obj.get("action")
        })
        return _obj


