# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_rule_spec_input_stream_custom import CoreV1RuleSpecInputStreamCustom
from dasl_api.models.core_v1_rule_spec_input_stream_tables_inner import CoreV1RuleSpecInputStreamTablesInner
from typing import Optional, Set
from typing_extensions import Self

class CoreV1RuleSpecInputStream(BaseModel):
    """
    A structured steaming input. This requires at least one delta table that a read stream will be generated from. 
    """ # noqa: E501
    tables: Optional[List[CoreV1RuleSpecInputStreamTablesInner]] = Field(default=None, description="A table that data can be collected from. ")
    filter: Optional[StrictStr] = Field(default=None, description="A filter expression to be applied to the input stream. Note that this cannot be used in conjunction with a custom SQL expression. ")
    sql: Optional[StrictStr] = Field(default=None, description="A custom SQL expression to apply to the input stream before matching. Note that this cannot be used in conjunction with a filter expression. ")
    custom: Optional[CoreV1RuleSpecInputStreamCustom] = None
    __properties: ClassVar[List[str]] = ["tables", "filter", "sql", "custom"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecInputStream from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tables (list)
        _items = []
        if self.tables:
            for _item_tables in self.tables:
                if _item_tables:
                    _items.append(_item_tables.to_dict())
            _dict['tables'] = _items
        # override the default output from pydantic by calling `to_dict()` of custom
        if self.custom:
            _dict['custom'] = self.custom.to_dict()
        # set to None if tables (nullable) is None
        # and model_fields_set contains the field
        if self.tables is None and "tables" in self.model_fields_set:
            _dict['tables'] = None

        # set to None if filter (nullable) is None
        # and model_fields_set contains the field
        if self.filter is None and "filter" in self.model_fields_set:
            _dict['filter'] = None

        # set to None if sql (nullable) is None
        # and model_fields_set contains the field
        if self.sql is None and "sql" in self.model_fields_set:
            _dict['sql'] = None

        # set to None if custom (nullable) is None
        # and model_fields_set contains the field
        if self.custom is None and "custom" in self.model_fields_set:
            _dict['custom'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecInputStream from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tables": [CoreV1RuleSpecInputStreamTablesInner.from_dict(_item) for _item in obj["tables"]] if obj.get("tables") is not None else None,
            "filter": obj.get("filter"),
            "sql": obj.get("sql"),
            "custom": CoreV1RuleSpecInputStreamCustom.from_dict(obj["custom"]) if obj.get("custom") is not None else None
        })
        return _obj


