# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.dbui_v1_notable_collate import DbuiV1NotableCollate
from dasl_api.models.dbui_v1_observable_instance import DbuiV1ObservableInstance
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1Notable(BaseModel):
    """
    DbuiV1Notable
    """ # noqa: E501
    id: StrictStr
    summary: StrictStr
    context: Dict[str, StrictStr]
    state: StrictStr
    assigned_to: Optional[StrictStr] = Field(default=None, alias="assignedTo")
    rule: Dict[str, Any]
    observables: List[DbuiV1ObservableInstance]
    severity: Optional[StrictStr] = None
    collate: DbuiV1NotableCollate
    __properties: ClassVar[List[str]] = ["id", "summary", "context", "state", "assignedTo", "rule", "observables", "severity", "collate"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Open', 'Assigned', 'ClosedAsFalsePositive', 'ClosedAsBenignPositive', 'ClosedAsTruePositiveResolved', 'ClosedAsExported']):
            raise ValueError("must be one of enum values ('Open', 'Assigned', 'ClosedAsFalsePositive', 'ClosedAsBenignPositive', 'ClosedAsTruePositiveResolved', 'ClosedAsExported')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1Notable from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in observables (list)
        _items = []
        if self.observables:
            for _item_observables in self.observables:
                if _item_observables:
                    _items.append(_item_observables.to_dict())
            _dict['observables'] = _items
        # override the default output from pydantic by calling `to_dict()` of collate
        if self.collate:
            _dict['collate'] = self.collate.to_dict()
        # set to None if assigned_to (nullable) is None
        # and model_fields_set contains the field
        if self.assigned_to is None and "assigned_to" in self.model_fields_set:
            _dict['assignedTo'] = None

        # set to None if severity (nullable) is None
        # and model_fields_set contains the field
        if self.severity is None and "severity" in self.model_fields_set:
            _dict['severity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1Notable from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "summary": obj.get("summary"),
            "context": obj.get("context"),
            "state": obj.get("state"),
            "assignedTo": obj.get("assignedTo"),
            "rule": obj.get("rule"),
            "observables": [DbuiV1ObservableInstance.from_dict(_item) for _item in obj["observables"]] if obj.get("observables") is not None else None,
            "severity": obj.get("severity"),
            "collate": DbuiV1NotableCollate.from_dict(obj["collate"]) if obj.get("collate") is not None else None
        })
        return _obj


