# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from dasl_api.models.dbui_v1_observable_events_list_items_inner_notable import DbuiV1ObservableEventsListItemsInnerNotable
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1ObservableEventsListItemsInner(BaseModel):
    """
    DbuiV1ObservableEventsListItemsInner
    """ # noqa: E501
    var_from: Optional[StrictStr] = Field(default=None, alias="from")
    adjust_by: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="adjustBy")
    notable: Optional[DbuiV1ObservableEventsListItemsInnerNotable] = None
    __properties: ClassVar[List[str]] = ["from", "adjustBy", "notable"]

    @field_validator('var_from')
    def var_from_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['notable', 'manual', 'automatic']):
            raise ValueError("must be one of enum values ('notable', 'manual', 'automatic')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1ObservableEventsListItemsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of notable
        if self.notable:
            _dict['notable'] = self.notable.to_dict()
        # set to None if var_from (nullable) is None
        # and model_fields_set contains the field
        if self.var_from is None and "var_from" in self.model_fields_set:
            _dict['from'] = None

        # set to None if adjust_by (nullable) is None
        # and model_fields_set contains the field
        if self.adjust_by is None and "adjust_by" in self.model_fields_set:
            _dict['adjustBy'] = None

        # set to None if notable (nullable) is None
        # and model_fields_set contains the field
        if self.notable is None and "notable" in self.model_fields_set:
            _dict['notable'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1ObservableEventsListItemsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "from": obj.get("from"),
            "adjustBy": obj.get("adjustBy"),
            "notable": DbuiV1ObservableEventsListItemsInnerNotable.from_dict(obj["notable"]) if obj.get("notable") is not None else None
        })
        return _obj


