# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.workspace_v1_admin_config_spec_auth_app_client_id import WorkspaceV1AdminConfigSpecAuthAppClientId
from dasl_api.models.workspace_v1_admin_config_spec_auth_service_principal import WorkspaceV1AdminConfigSpecAuthServicePrincipal
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1AdminConfigSpecAuth(BaseModel):
    """
    Authentication configuration items.
    """ # noqa: E501
    host: StrictStr = Field(description="The Databricks URL for the Databricks workspace.")
    service_principal: Optional[WorkspaceV1AdminConfigSpecAuthServicePrincipal] = Field(default=None, alias="servicePrincipal")
    app_client_id: Optional[WorkspaceV1AdminConfigSpecAuthAppClientId] = Field(default=None, alias="appClientId")
    __properties: ClassVar[List[str]] = ["host", "servicePrincipal", "appClientId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1AdminConfigSpecAuth from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of service_principal
        if self.service_principal:
            _dict['servicePrincipal'] = self.service_principal.to_dict()
        # override the default output from pydantic by calling `to_dict()` of app_client_id
        if self.app_client_id:
            _dict['appClientId'] = self.app_client_id.to_dict()
        # set to None if service_principal (nullable) is None
        # and model_fields_set contains the field
        if self.service_principal is None and "service_principal" in self.model_fields_set:
            _dict['servicePrincipal'] = None

        # set to None if app_client_id (nullable) is None
        # and model_fields_set contains the field
        if self.app_client_id is None and "app_client_id" in self.model_fields_set:
            _dict['appClientId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1AdminConfigSpecAuth from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "host": obj.get("host"),
            "servicePrincipal": WorkspaceV1AdminConfigSpecAuthServicePrincipal.from_dict(obj["servicePrincipal"]) if obj.get("servicePrincipal") is not None else None,
            "appClientId": WorkspaceV1AdminConfigSpecAuthAppClientId.from_dict(obj["appClientId"]) if obj.get("appClientId") is not None else None
        })
        return _obj


