# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1AuthenticateRequest(BaseModel):
    """
    A request to authenticate with a workspace. 
    """ # noqa: E501
    service_account_key: Optional[StrictStr] = Field(default=None, description="A service account API key", alias="serviceAccountKey")
    databricks_api_token: Optional[StrictStr] = Field(default=None, description="An API token for the databricks API", alias="databricksApiToken")
    databricks_secret: Optional[StrictStr] = Field(default=None, description="The contents of the databricks authentication secret", alias="databricksSecret")
    __properties: ClassVar[List[str]] = ["serviceAccountKey", "databricksApiToken", "databricksSecret"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1AuthenticateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if service_account_key (nullable) is None
        # and model_fields_set contains the field
        if self.service_account_key is None and "service_account_key" in self.model_fields_set:
            _dict['serviceAccountKey'] = None

        # set to None if databricks_api_token (nullable) is None
        # and model_fields_set contains the field
        if self.databricks_api_token is None and "databricks_api_token" in self.model_fields_set:
            _dict['databricksApiToken'] = None

        # set to None if databricks_secret (nullable) is None
        # and model_fields_set contains the field
        if self.databricks_secret is None and "databricks_secret" in self.model_fields_set:
            _dict['databricksSecret'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1AuthenticateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "serviceAccountKey": obj.get("serviceAccountKey"),
            "databricksApiToken": obj.get("databricksApiToken"),
            "databricksSecret": obj.get("databricksSecret")
        })
        return _obj


