# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.workspace_v1_export_config_jira_config_token import WorkspaceV1ExportConfigJiraConfigToken
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1ExportConfigJiraConfig(BaseModel):
    """
    WorkspaceV1ExportConfigJiraConfig
    """ # noqa: E501
    server: Optional[StrictStr] = Field(default=None, description="Full URL of the Atlassian instance. ")
    project: Optional[StrictStr] = Field(default=None, description="Name of the Jira project in which to create tickets. ")
    issue_type: Optional[StrictStr] = Field(default=None, description="The type of Jira issue (e.g. Task) that should be created in the project. If in doubt, Task is likely (but not certainly) a safe choice. ", alias="issueType")
    summary: Optional[StrictStr] = Field(default=None, description="Event string template used to compute the title of the Jira tickets to be raised. The description of the ticket will contain the JSON-serialized notable or operational alert. ")
    email: Optional[StrictStr] = Field(default=None, description="Email of the user who will auth to Jira. The token must be an API token for this user. ")
    token: Optional[WorkspaceV1ExportConfigJiraConfigToken] = None
    __properties: ClassVar[List[str]] = ["server", "project", "issueType", "summary", "email", "token"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1ExportConfigJiraConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of token
        if self.token:
            _dict['token'] = self.token.to_dict()
        # set to None if server (nullable) is None
        # and model_fields_set contains the field
        if self.server is None and "server" in self.model_fields_set:
            _dict['server'] = None

        # set to None if project (nullable) is None
        # and model_fields_set contains the field
        if self.project is None and "project" in self.model_fields_set:
            _dict['project'] = None

        # set to None if issue_type (nullable) is None
        # and model_fields_set contains the field
        if self.issue_type is None and "issue_type" in self.model_fields_set:
            _dict['issueType'] = None

        # set to None if summary (nullable) is None
        # and model_fields_set contains the field
        if self.summary is None and "summary" in self.model_fields_set:
            _dict['summary'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if token (nullable) is None
        # and model_fields_set contains the field
        if self.token is None and "token" in self.model_fields_set:
            _dict['token'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1ExportConfigJiraConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "server": obj.get("server"),
            "project": obj.get("project"),
            "issueType": obj.get("issueType"),
            "summary": obj.get("summary"),
            "email": obj.get("email"),
            "token": WorkspaceV1ExportConfigJiraConfigToken.from_dict(obj["token"]) if obj.get("token") is not None else None
        })
        return _obj


