# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.workspace_v1_export_config_service_now_config_password import WorkspaceV1ExportConfigServiceNowConfigPassword
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1ExportConfigServiceNowConfig(BaseModel):
    """
    WorkspaceV1ExportConfigServiceNowConfig
    """ # noqa: E501
    server: Optional[StrictStr] = Field(default=None, description="Full URL of the ServiceNow instance. For example, \"https://my-instance.service-now.com\" ")
    source_expr: Optional[StrictStr] = Field(default=None, description="Event string template used to compute the \"source\" field of the posted event. If this value is not specified, the event will be posted with a \"source\" of \"dasl\". ", alias="sourceExpr")
    node_expr: Optional[StrictStr] = Field(default=None, description="Event string template used to compute the \"node\" field of the posted event. This field is generally used to identity the specific host or device that generated the event. If this value is not specified, the event will be posted without a \"node\" field. ", alias="nodeExpr")
    severity_expr: Optional[StrictStr] = Field(default=None, description="Event string template used to compute the Severity of the event. This expression should evaluate to an integer value between 0 and 5, where 0=Clear, 1=Critical, 2=Major, 3=Minor, 4=Warning, and 5=Informational. If there is an issue with this expression, the event in ServiceNow, after being processed, will be in the \"Error\" state. ", alias="severityExpr")
    event_type: Optional[StrictStr] = Field(default=None, description="The type of the event that will be posted to ServiceNow. If this value is not specified, the event will be posted with the \"Security\" type, which is compatible with the Security Incident Response plugin. ", alias="eventType")
    user_id: Optional[StrictStr] = Field(default=None, description="User ID in ServiceNow of the integration user with the `evt_mgmt_integration` role. ", alias="userID")
    password: Optional[WorkspaceV1ExportConfigServiceNowConfigPassword] = None
    __properties: ClassVar[List[str]] = ["server", "sourceExpr", "nodeExpr", "severityExpr", "eventType", "userID", "password"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1ExportConfigServiceNowConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of password
        if self.password:
            _dict['password'] = self.password.to_dict()
        # set to None if server (nullable) is None
        # and model_fields_set contains the field
        if self.server is None and "server" in self.model_fields_set:
            _dict['server'] = None

        # set to None if source_expr (nullable) is None
        # and model_fields_set contains the field
        if self.source_expr is None and "source_expr" in self.model_fields_set:
            _dict['sourceExpr'] = None

        # set to None if node_expr (nullable) is None
        # and model_fields_set contains the field
        if self.node_expr is None and "node_expr" in self.model_fields_set:
            _dict['nodeExpr'] = None

        # set to None if severity_expr (nullable) is None
        # and model_fields_set contains the field
        if self.severity_expr is None and "severity_expr" in self.model_fields_set:
            _dict['severityExpr'] = None

        # set to None if event_type (nullable) is None
        # and model_fields_set contains the field
        if self.event_type is None and "event_type" in self.model_fields_set:
            _dict['eventType'] = None

        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['userID'] = None

        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1ExportConfigServiceNowConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "server": obj.get("server"),
            "sourceExpr": obj.get("sourceExpr"),
            "nodeExpr": obj.get("nodeExpr"),
            "severityExpr": obj.get("severityExpr"),
            "eventType": obj.get("eventType"),
            "userID": obj.get("userID"),
            "password": WorkspaceV1ExportConfigServiceNowConfigPassword.from_dict(obj["password"]) if obj.get("password") is not None else None
        })
        return _obj


