# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.workspace_v1_rebalance_info_status_resources_inner import WorkspaceV1RebalanceInfoStatusResourcesInner
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1RebalanceInfoStatus(BaseModel):
    """
    WorkspaceV1RebalanceInfoStatus
    """ # noqa: E501
    status: Optional[StrictStr] = 'idle'
    start_time: Optional[datetime] = Field(default=None, alias="startTime")
    finish_time: Optional[datetime] = Field(default=None, alias="finishTime")
    total_resources: Optional[StrictInt] = Field(default=None, alias="totalResources")
    completed_resources: Optional[StrictInt] = Field(default=None, alias="completedResources")
    resources: Optional[List[WorkspaceV1RebalanceInfoStatusResourcesInner]] = None
    __properties: ClassVar[List[str]] = ["status", "startTime", "finishTime", "totalResources", "completedResources", "resources"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['idle', 'active']):
            raise ValueError("must be one of enum values ('idle', 'active')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1RebalanceInfoStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in resources (list)
        _items = []
        if self.resources:
            for _item_resources in self.resources:
                if _item_resources:
                    _items.append(_item_resources.to_dict())
            _dict['resources'] = _items
        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if start_time (nullable) is None
        # and model_fields_set contains the field
        if self.start_time is None and "start_time" in self.model_fields_set:
            _dict['startTime'] = None

        # set to None if finish_time (nullable) is None
        # and model_fields_set contains the field
        if self.finish_time is None and "finish_time" in self.model_fields_set:
            _dict['finishTime'] = None

        # set to None if total_resources (nullable) is None
        # and model_fields_set contains the field
        if self.total_resources is None and "total_resources" in self.model_fields_set:
            _dict['totalResources'] = None

        # set to None if completed_resources (nullable) is None
        # and model_fields_set contains the field
        if self.completed_resources is None and "completed_resources" in self.model_fields_set:
            _dict['completedResources'] = None

        # set to None if resources (nullable) is None
        # and model_fields_set contains the field
        if self.resources is None and "resources" in self.model_fields_set:
            _dict['resources'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1RebalanceInfoStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status") if obj.get("status") is not None else 'idle',
            "startTime": obj.get("startTime"),
            "finishTime": obj.get("finishTime"),
            "totalResources": obj.get("totalResources"),
            "completedResources": obj.get("completedResources"),
            "resources": [WorkspaceV1RebalanceInfoStatusResourcesInner.from_dict(_item) for _item in obj["resources"]] if obj.get("resources") is not None else None
        })
        return _obj


