# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.21
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1WorkspaceConfigSpecManagedRetentionInnerOverridesInner(BaseModel):
    """
    WorkspaceV1WorkspaceConfigSpecManagedRetentionInnerOverridesInner
    """ # noqa: E501
    table: StrictStr = Field(description="The table name this override applies to.")
    column: Optional[StrictStr] = Field(default='time', description="The time column to check for retention. The referenced column must be TIMESTAMP compatiable.")
    duration: Optional[StrictStr] = Field(default=None, description="The duration to retain data in the schema for. Default is 3 years The string may contain components for days, hours, minutes and seconds. Examples include '5d', '5d3h', '3d2h5m12s', and '12m16s'. It may also be \"forever\" to indicate data should not be deleted from tables in this schema. ")
    __properties: ClassVar[List[str]] = ["table", "column", "duration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpecManagedRetentionInnerOverridesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if column (nullable) is None
        # and model_fields_set contains the field
        if self.column is None and "column" in self.model_fields_set:
            _dict['column'] = None

        # set to None if duration (nullable) is None
        # and model_fields_set contains the field
        if self.duration is None and "duration" in self.model_fields_set:
            _dict['duration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpecManagedRetentionInnerOverridesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "table": obj.get("table"),
            "column": obj.get("column") if obj.get("column") is not None else 'time',
            "duration": obj.get("duration")
        })
        return _obj


