# MeshAgent Python SDK

MeshAgent is your platform to create, deploy, and manage AI agents collaboratively and at scale, securely and in real time. 

MeshAgent removes the infrastructure headaches of building and shipping AI Agents. It spins up secure, real-time "Rooms" that connect humans, agents, and shared context -- letting you launch, share, and refine agents in hours instead of weeks.

---

**Documentation**: [docs.meshagent.com](https://docs.meshagent.com/)

**Website**: [www.meshagent.com](https://www.meshagent.com/)

**MeshAgent Studio**: [studio.meshagent.com](https://studio.meshagent.com/)

---

## Why MeshAgent? 

- **Real-time multi-user "Rooms" for true human-AI teamwork**: Secure workspaces, "Rooms", automatically spin-up when someone joins, tracking presence, chat, documents, and agent activity, and disappear when everyone leaves -- so people and agents stay in sync. 

- **Accelerated feedback loop and shortened development cycle**: Invite a colleague or stakeholder into the MeshAgent Studio Room so they can see, hear, and interact with your agent immediately -- letting you demo, gather feedback, and iterate on the agent on the same day.

- **Shareable links that showcase your agent**: After you deploy an agent, MeshAgent provides you a URL so colleagues or customers can jump straight into the Room, try the agent, and give feedback -- no code checkout, IDE, or GPU required. 

- **Reusable and extensibly agent tools**: MeshAgent ships prebuilt, reusable toolkits for common Room interactions (e.g., file and document handling, media generation, dynamic UI interactions) and high-demand tasks (e.g., web search or document-to-Markdown conversion). Support for custom tools and the Model Context Protocol (MCP) enables you to seamlessly integrate any MCP-compatible service into a Room without changes to your applications. Tools are centrally managed like agents, allowing you to deploy them once and reuse them effortlessly.

- **Built-in Observability**: Streaming logs and traces give you real-time insight into every message, agent action, and error. 

- **Secure and elastic by default**: Project-scoped keys, on-demand provisioning, and auto-scaling infrastructure keep Rooms private, secure, and ready for your usage needs.

- **Support across languages**: The same feature set (Rooms, Agents, Tools, Messaging, Queues, Storage, Documents, etc.) is exposed through official Python, Javascript, Typescript, and Dart SDKs, so every team member can work in their preferred language. 

## Getting Setup

Follow our [Getting Started Documentation](https://docs.meshagent.com/introduction/get_started) to setup your MeshAgent account, create your first project, and start building agents!

## Next Steps and Examples

To see examples of agents in action and to start building your own agents check out the MeshAgent docs at [docs.meshagent.com](https://docs.meshagent.com/)
