# Copyright (C) 2022 CVAT.ai Corporation
#
# SPDX-License-Identifier: MIT

# CVAT REST API
#
# REST API for Computer Vision Annotation Tool (CVAT)  # noqa: E501
#
# The version of the OpenAPI document: 2.42.0
# Contact: support@cvat.ai
# Generated by: https://openapi-generator.tech


from __future__ import annotations

import typing
import urllib3

import re  # noqa: F401

from cvat_sdk.api_client.api_client import ApiClient, Endpoint as _Endpoint
from cvat_sdk.api_client.model_utils import (  # noqa: F401
    date,
    datetime,
    file_type,
    none_type,
)
from cvat_sdk.api_client.model.annotation_file_request import AnnotationFileRequest
from cvat_sdk.api_client.model.data_meta_read import DataMetaRead
from cvat_sdk.api_client.model.data_request import DataRequest
from cvat_sdk.api_client.model.data_response import DataResponse
from cvat_sdk.api_client.model.labeled_data import LabeledData
from cvat_sdk.api_client.model.labeled_data_request import LabeledDataRequest
from cvat_sdk.api_client.model.paginated_task_read_list import PaginatedTaskReadList
from cvat_sdk.api_client.model.patched_data_meta_write_request import PatchedDataMetaWriteRequest
from cvat_sdk.api_client.model.patched_labeled_data_request import PatchedLabeledDataRequest
from cvat_sdk.api_client.model.patched_task_validation_layout_write_request import PatchedTaskValidationLayoutWriteRequest
from cvat_sdk.api_client.model.patched_task_write_request import PatchedTaskWriteRequest
from cvat_sdk.api_client.model.rq_id import RqId
from cvat_sdk.api_client.model.rq_status import RqStatus
from cvat_sdk.api_client.model.task_file_request import TaskFileRequest
from cvat_sdk.api_client.model.task_read import TaskRead
from cvat_sdk.api_client.model.task_validation_layout_read import TaskValidationLayoutRead
from cvat_sdk.api_client.model.task_write_request import TaskWriteRequest

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    # Enable introspection. Can't work normally due to cyclic imports
    from cvat_sdk.api_client.apis import *
    from cvat_sdk.api_client.models import *


class TasksApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_endpoint = _Endpoint(
            settings={
                'response_schema': (TaskRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks',
                'operation_id': 'create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'task_write_request',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'task_write_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'task_write_request':
                        (TaskWriteRequest,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'task_write_request': 'body',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/annotations/',
                'operation_id': 'create_annotations',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'cloud_storage_id',
                    'filename',
                    'format',
                    'location',
                    'use_default_location',
                    'annotation_file_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'location',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('location',): {

                        "CLOUD_STORAGE": "cloud_storage",
                        "LOCAL": "local"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'cloud_storage_id':
                        (int,),
                    'filename':
                        (str,),
                    'format':
                        (str,),
                    'location':
                        (str,),
                    'use_default_location':
                        (bool,),
                    'annotation_file_request':
                        (AnnotationFileRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                    'cloud_storage_id': 'cloud_storage_id',
                    'filename': 'filename',
                    'format': 'format',
                    'location': 'location',
                    'use_default_location': 'use_default_location',
                },
                'location_map': {
                    'id': 'path',
                    'cloud_storage_id': 'query',
                    'filename': 'query',
                    'format': 'query',
                    'location': 'query',
                    'use_default_location': 'query',
                    'annotation_file_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_backup_endpoint = _Endpoint(
            settings={
                'response_schema': (RqId,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/backup/',
                'operation_id': 'create_backup',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_organization',
                    'cloud_storage_id',
                    'filename',
                    'location',
                    'org',
                    'org_id',
                    'task_file_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'location',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('location',): {

                        "CLOUD_STORAGE": "cloud_storage",
                        "LOCAL": "local"
                    },
                },
                'openapi_types': {
                    'x_organization':
                        (str,),
                    'cloud_storage_id':
                        (int,),
                    'filename':
                        (str,),
                    'location':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'task_file_request':
                        (TaskFileRequest,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'cloud_storage_id': 'cloud_storage_id',
                    'filename': 'filename',
                    'location': 'location',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'x_organization': 'header',
                    'cloud_storage_id': 'query',
                    'filename': 'query',
                    'location': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'task_file_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_backup_export_endpoint = _Endpoint(
            settings={
                'response_schema': (RqId,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/backup/export',
                'operation_id': 'create_backup_export',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'cloud_storage_id',
                    'filename',
                    'location',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'location',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('location',): {

                        "CLOUD_STORAGE": "cloud_storage",
                        "LOCAL": "local"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'cloud_storage_id':
                        (int,),
                    'filename':
                        (str,),
                    'location':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'cloud_storage_id': 'cloud_storage_id',
                    'filename': 'filename',
                    'location': 'location',
                },
                'location_map': {
                    'id': 'path',
                    'cloud_storage_id': 'query',
                    'filename': 'query',
                    'location': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_data_endpoint = _Endpoint(
            settings={
                'response_schema': (DataResponse,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/data/',
                'operation_id': 'create_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'upload_finish',
                    'upload_multiple',
                    'upload_start',
                    'data_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'upload_finish':
                        (bool,),
                    'upload_multiple':
                        (bool,),
                    'upload_start':
                        (bool,),
                    'data_request':
                        (DataRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                    'upload_finish': 'Upload-Finish',
                    'upload_multiple': 'Upload-Multiple',
                    'upload_start': 'Upload-Start',
                },
                'location_map': {
                    'id': 'path',
                    'upload_finish': 'header',
                    'upload_multiple': 'header',
                    'upload_start': 'header',
                    'data_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_dataset_export_endpoint = _Endpoint(
            settings={
                'response_schema': (RqId,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/dataset/export',
                'operation_id': 'create_dataset_export',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'format',
                    'id',
                    'cloud_storage_id',
                    'filename',
                    'location',
                    'save_images',
                ],
                'required': [
                    'format',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'location',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('location',): {

                        "CLOUD_STORAGE": "cloud_storage",
                        "LOCAL": "local"
                    },
                },
                'openapi_types': {
                    'format':
                        (str,),
                    'id':
                        (int,),
                    'cloud_storage_id':
                        (int,),
                    'filename':
                        (str,),
                    'location':
                        (str,),
                    'save_images':
                        (bool,),
                },
                'attribute_map': {
                    'format': 'format',
                    'id': 'id',
                    'cloud_storage_id': 'cloud_storage_id',
                    'filename': 'filename',
                    'location': 'location',
                    'save_images': 'save_images',
                },
                'location_map': {
                    'format': 'query',
                    'id': 'path',
                    'cloud_storage_id': 'query',
                    'filename': 'query',
                    'location': 'query',
                    'save_images': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.destroy_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}',
                'operation_id': 'destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.destroy_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/annotations/',
                'operation_id': 'destroy_annotations',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_endpoint = _Endpoint(
            settings={
                'response_schema': (PaginatedTaskReadList,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks',
                'operation_id': 'list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_organization',
                    'assignee',
                    'dimension',
                    'filter',
                    'mode',
                    'name',
                    'org',
                    'org_id',
                    'owner',
                    'page',
                    'page_size',
                    'project_id',
                    'project_name',
                    'search',
                    'sort',
                    'status',
                    'subset',
                    'tracker_link',
                    'validation_mode',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'dimension',
                    'status',
                    'validation_mode',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('dimension',): {

                        "3D": "3d",
                        "2D": "2d"
                    },
                    ('status',): {

                        "ANNOTATION": "annotation",
                        "VALIDATION": "validation",
                        "COMPLETED": "completed"
                    },
                    ('validation_mode',): {

                        "GT": "gt",
                        "GT_POOL": "gt_pool"
                    },
                },
                'openapi_types': {
                    'x_organization':
                        (str,),
                    'assignee':
                        (str,),
                    'dimension':
                        (str,),
                    'filter':
                        (str,),
                    'mode':
                        (str,),
                    'name':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'owner':
                        (str,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'project_id':
                        (int,),
                    'project_name':
                        (str,),
                    'search':
                        (str,),
                    'sort':
                        (str,),
                    'status':
                        (str,),
                    'subset':
                        (str,),
                    'tracker_link':
                        (str,),
                    'validation_mode':
                        (str,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'assignee': 'assignee',
                    'dimension': 'dimension',
                    'filter': 'filter',
                    'mode': 'mode',
                    'name': 'name',
                    'org': 'org',
                    'org_id': 'org_id',
                    'owner': 'owner',
                    'page': 'page',
                    'page_size': 'page_size',
                    'project_id': 'project_id',
                    'project_name': 'project_name',
                    'search': 'search',
                    'sort': 'sort',
                    'status': 'status',
                    'subset': 'subset',
                    'tracker_link': 'tracker_link',
                    'validation_mode': 'validation_mode',
                },
                'location_map': {
                    'x_organization': 'header',
                    'assignee': 'query',
                    'dimension': 'query',
                    'filter': 'query',
                    'mode': 'query',
                    'name': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'owner': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'project_id': 'query',
                    'project_name': 'query',
                    'search': 'query',
                    'sort': 'query',
                    'status': 'query',
                    'subset': 'query',
                    'tracker_link': 'query',
                    'validation_mode': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.partial_update_endpoint = _Endpoint(
            settings={
                'response_schema': (TaskRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}',
                'operation_id': 'partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_task_write_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_task_write_request':
                        (PatchedTaskWriteRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_task_write_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.partial_update_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': (LabeledData,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/annotations/',
                'operation_id': 'partial_update_annotations',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'action',
                    'id',
                    'patched_labeled_data_request',
                ],
                'required': [
                    'action',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'action',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('action',): {

                        "CREATE": "create",
                        "DELETE": "delete",
                        "UPDATE": "update"
                    },
                },
                'openapi_types': {
                    'action':
                        (str,),
                    'id':
                        (int,),
                    'patched_labeled_data_request':
                        (PatchedLabeledDataRequest,),
                },
                'attribute_map': {
                    'action': 'action',
                    'id': 'id',
                },
                'location_map': {
                    'action': 'query',
                    'id': 'path',
                    'patched_labeled_data_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.partial_update_data_meta_endpoint = _Endpoint(
            settings={
                'response_schema': (DataMetaRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/data/meta',
                'operation_id': 'partial_update_data_meta',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_data_meta_write_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_data_meta_write_request':
                        (PatchedDataMetaWriteRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_data_meta_write_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.partial_update_validation_layout_endpoint = _Endpoint(
            settings={
                'response_schema': (TaskValidationLayoutRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/validation_layout',
                'operation_id': 'partial_update_validation_layout',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_task_validation_layout_write_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_task_validation_layout_write_request':
                        (PatchedTaskValidationLayoutWriteRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_task_validation_layout_write_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.retrieve_endpoint = _Endpoint(
            settings={
                'response_schema': (TaskRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}',
                'operation_id': 'retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': (LabeledData,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/annotations/',
                'operation_id': 'retrieve_annotations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_data_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/data/',
                'operation_id': 'retrieve_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'number',
                    'quality',
                    'type',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'quality',
                    'type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('quality',): {

                        "COMPRESSED": "compressed",
                        "ORIGINAL": "original"
                    },
                    ('type',): {

                        "CHUNK": "chunk",
                        "CONTEXT_IMAGE": "context_image",
                        "FRAME": "frame"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'number':
                        (int,),
                    'quality':
                        (str,),
                    'type':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'number': 'number',
                    'quality': 'quality',
                    'type': 'type',
                },
                'location_map': {
                    'id': 'path',
                    'number': 'query',
                    'quality': 'query',
                    'type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_data_meta_endpoint = _Endpoint(
            settings={
                'response_schema': (DataMetaRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/data/meta',
                'operation_id': 'retrieve_data_meta',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_preview_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/preview',
                'operation_id': 'retrieve_preview',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_status_endpoint = _Endpoint(
            settings={
                'response_schema': (RqStatus,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/status',
                'operation_id': 'retrieve_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_validation_layout_endpoint = _Endpoint(
            settings={
                'response_schema': (TaskValidationLayoutRead,),
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/validation_layout',
                'operation_id': 'retrieve_validation_layout',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'signatureAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/tasks/{id}/annotations/',
                'operation_id': 'update_annotations',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'labeled_data_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'labeled_data_request':
                        (LabeledDataRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'labeled_data_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def create(
        self,
        task_write_request: TaskWriteRequest,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[TaskRead], urllib3.HTTPResponse]:
        """Create a task  # noqa: E501

        The new task will not have any attached images or videos. To attach them, use the /api/tasks/<id>/data endpoint.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create(task_write_request, _async_call=True)
        >>> result = thread.get()

        Args:
            task_write_request (TaskWriteRequest):

        Keyword Args:
            x_organization (str): Organization unique slug. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (TaskRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['task_write_request'] = task_write_request
        return self.create_endpoint.call_with_http_info(**kwargs)

    def create_annotations(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Import annotations into a task  # noqa: E501

         The request POST /api/tasks/id/annotations initiates a background process to import annotations into a task. Please, use the GET /api/requests/<rq_id> endpoint for checking status of the process. The `rq_id` parameter can be found in the response on initiating request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_annotations(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            cloud_storage_id (int): Storage id. [optional]
            filename (str): Annotation file name. [optional]
            format (str): Input format name You can get the list of supported formats at: /server/annotation/formats. [optional]
            location (str): where to import the annotation from. [optional]
            use_default_location (bool): Use the location that was configured in task to import annotations. [optional] if omitted the server will use the default value of True
            annotation_file_request (AnnotationFileRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.create_annotations_endpoint.call_with_http_info(**kwargs)

    def create_backup(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[RqId], urllib3.HTTPResponse]:
        """Recreate a task from a backup  # noqa: E501

         The backup import process is as follows:  The first request POST /api/tasks/backup creates a background job on the server in which the process of a task creating from an uploaded backup is carried out.  To check the status of the import process, use GET /api/requests/rq_id, where rq_id is the request ID obtained from the response to the previous request.  Once the import completes successfully, the response will contain the ID of the newly created task in the result_id field.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_backup(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            x_organization (str): Organization unique slug. [optional]
            cloud_storage_id (int): Storage id. [optional]
            filename (str): Backup file name. [optional]
            location (str): Where to import the backup file from. [optional] if omitted the server will use the default value of "local"
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            task_file_request (TaskFileRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (RqId, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.create_backup_endpoint.call_with_http_info(**kwargs)

    def create_backup_export(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[RqId], urllib3.HTTPResponse]:
        """Initiate process to backup resource  # noqa: E501

        The request `POST /api/<projects|tasks>/id/backup/export` will initialize a background process to backup a resource. To check status of the process please, use `GET /api/requests/<rq_id>` where **rq_id** is request ID returned in the response for this endpoint.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_backup_export(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            cloud_storage_id (int): Storage id. [optional]
            filename (str): Backup file name. [optional]
            location (str): Where need to save downloaded backup. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (RqId, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.create_backup_export_endpoint.call_with_http_info(**kwargs)

    def create_data(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[DataResponse], urllib3.HTTPResponse]:
        """Attach data to a task  # noqa: E501

        Allows to upload data (images, video, etc.) to a task. Supports the TUS open file uploading protocol (https://tus.io/).  Supports the following protocols:  1. A single Data request  and  2.1. An Upload-Start request 2.2.a. Regular TUS protocol requests (Upload-Length + Chunks) 2.2.b. Upload-Multiple requests 2.3. An Upload-Finish request  Requests: - Data - POST, no extra headers or 'Upload-Start' + 'Upload-Finish' headers.   Contains data in the body. - Upload-Start - POST, has an 'Upload-Start' header. No body is expected. - Upload-Length - POST, has an 'Upload-Length' header (see the TUS specification) - Chunk - HEAD/PATCH (see the TUS specification). Sent to /data/<file id> endpoints. - Upload-Finish - POST, has an 'Upload-Finish' header. Can contain data in the body. - Upload-Multiple - POST, has an 'Upload-Multiple' header. Contains data in the body.  The 'Upload-Finish' request allows to specify the uploaded files should be ordered. This may be needed if the files can be sent unordered. To state that the input files are sent ordered, pass an empty list of files in the 'upload_file_order' field. If the files are sent unordered, the ordered file list is expected in the 'upload_file_order' field. It must be a list of string file paths, relative to the dataset root.  Example: files = [     \"cats/cat_1.jpg\",     \"dogs/dog2.jpg\",     \"image_3.png\",     ... ]  Independently of the file declaration field used ('client_files', 'server_files', etc.), when the 'predefined' sorting method is selected, the uploaded files will be ordered according to the '.jsonl' manifest file, if it is found in the list of files. For archives (e.g. '.zip'), a manifest file ('*.jsonl') is required when using the 'predefined' file ordering. Such file must be provided next to the archive in the list of files. Read more about manifest files here: https://docs.cvat.ai/docs/manual/advanced/dataset_manifest/  After all data is sent, the operation status can be retrieved via the `GET /api/requests/<rq_id>`, where **rq_id** is request ID returned for this request.  Once data is attached to a task, it cannot be detached or replaced.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_data(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            upload_finish (bool): Finishes data upload. Can be combined with Upload-Start header to create task data with one request. [optional]
            upload_multiple (bool): Indicates that data with this request are single or multiple files that should be attached to a task. [optional]
            upload_start (bool): Initializes data upload. Optionally, can include upload metadata in the request body.. [optional]
            data_request (DataRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (DataResponse, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.create_data_endpoint.call_with_http_info(**kwargs)

    def create_dataset_export(
        self,
        format: str,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[RqId], urllib3.HTTPResponse]:
        """Initialize process to export resource as a dataset in a specific format  # noqa: E501

        The request `POST /api/<projects|tasks|jobs>/id/dataset/export` will initialize a background process to export a dataset. To check status of the process please, use `GET /api/requests/<rq_id>` where **rq_id** is request ID returned in the response for this endpoint.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_dataset_export(format, id, _async_call=True)
        >>> result = thread.get()

        Args:
            format (str): Desired output format name You can get the list of supported formats at: /server/annotation/formats
            id (int): A unique integer value identifying this task.

        Keyword Args:
            cloud_storage_id (int): Storage id. [optional]
            filename (str): Desired output file name. [optional]
            location (str): Where need to save downloaded dataset. [optional]
            save_images (bool): Include images or not. [optional] if omitted the server will use the default value of False
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (RqId, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['format'] = format
        kwargs['id'] = id
        return self.create_dataset_export_endpoint.call_with_http_info(**kwargs)

    def destroy(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Delete a task  # noqa: E501

        All attached jobs, annotations and data will be deleted as well.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.destroy(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.destroy_endpoint.call_with_http_info(**kwargs)

    def destroy_annotations(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Delete task annotations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.destroy_annotations(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.destroy_annotations_endpoint.call_with_http_info(**kwargs)

    def list(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[PaginatedTaskReadList], urllib3.HTTPResponse]:
        """List tasks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            x_organization (str): Organization unique slug. [optional]
            assignee (str): A simple equality filter for the assignee field. [optional]
            dimension (str): A simple equality filter for the dimension field. [optional]
            filter (str):  JSON Logic filter. This filter can be used to perform complex filtering by grouping rules.  For example, using such a filter you can get all resources created by you:      - {\"and\":[{\"==\":[{\"var\":\"owner\"},\"<user>\"]}]}  Details about the syntax used can be found at the link: https://jsonlogic.com/   Available filter_fields: ['project_name', 'name', 'owner', 'status', 'assignee', 'subset', 'mode', 'dimension', 'tracker_link', 'validation_mode', 'id', 'project_id', 'updated_date'].  There are few examples for complex filtering tasks:      - Get all tasks from 1,2,3 projects - { \"and\" : [{ \"in\" : [{ \"var\" : \"project_id\" }, [1, 2, 3]]}]}      - Get all completed tasks from 1 project - { \"and\": [{ \"==\": [{ \"var\" : \"status\" }, \"completed\"]}, { \"==\" : [{ \"var\" : \"project_id\"}, 1]}]}  . [optional]
            mode (str): A simple equality filter for the mode field. [optional]
            name (str): A simple equality filter for the name field. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            owner (str): A simple equality filter for the owner field. [optional]
            page (int): A page number within the paginated result set.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            project_id (int): A simple equality filter for the project_id field. [optional]
            project_name (str): A simple equality filter for the project_name field. [optional]
            search (str): A search term. Available search_fields: ('project_name', 'name', 'owner', 'status', 'assignee', 'subset', 'mode', 'dimension', 'tracker_link', 'validation_mode'). [optional]
            sort (str): Which field to use when ordering the results. Available ordering_fields: ['project_name', 'name', 'owner', 'status', 'assignee', 'subset', 'mode', 'dimension', 'tracker_link', 'validation_mode', 'id', 'project_id', 'updated_date']. [optional]
            status (str): A simple equality filter for the status field. [optional]
            subset (str): A simple equality filter for the subset field. [optional]
            tracker_link (str): A simple equality filter for the tracker_link field. [optional]
            validation_mode (str): A simple equality filter for the validation_mode field. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (PaginatedTaskReadList, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.list_endpoint.call_with_http_info(**kwargs)

    def partial_update(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[TaskRead], urllib3.HTTPResponse]:
        """Update a task  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.partial_update(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            patched_task_write_request (PatchedTaskWriteRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (TaskRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.partial_update_endpoint.call_with_http_info(**kwargs)

    def partial_update_annotations(
        self,
        action: str,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[LabeledData], urllib3.HTTPResponse]:
        """Update task annotations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.partial_update_annotations(action, id, _async_call=True)
        >>> result = thread.get()

        Args:
            action (str):
            id (int): A unique integer value identifying this task.

        Keyword Args:
            patched_labeled_data_request (PatchedLabeledDataRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (LabeledData, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['action'] = action
        kwargs['id'] = id
        return self.partial_update_annotations_endpoint.call_with_http_info(**kwargs)

    def partial_update_data_meta(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[DataMetaRead], urllib3.HTTPResponse]:
        """Update metainformation for media files in a task  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.partial_update_data_meta(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            patched_data_meta_write_request (PatchedDataMetaWriteRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (DataMetaRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.partial_update_data_meta_endpoint.call_with_http_info(**kwargs)

    def partial_update_validation_layout(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[TaskValidationLayoutRead], urllib3.HTTPResponse]:
        """Allows updating current validation configuration  # noqa: E501

         WARNING: this operation is not protected from race conditions. It's up to the user to ensure no parallel calls to this operation happen. It affects image access, including exports with images, backups, chunk downloading etc.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.partial_update_validation_layout(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            patched_task_validation_layout_write_request (PatchedTaskValidationLayoutWriteRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (TaskValidationLayoutRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.partial_update_validation_layout_endpoint.call_with_http_info(**kwargs)

    def retrieve(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[TaskRead], urllib3.HTTPResponse]:
        """Get task details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (TaskRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_endpoint.call_with_http_info(**kwargs)

    def retrieve_annotations(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[LabeledData], urllib3.HTTPResponse]:
        """Get task annotations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_annotations(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (LabeledData, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_annotations_endpoint.call_with_http_info(**kwargs)

    def retrieve_data(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Get data of a task  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_data(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            number (int): A unique number value identifying chunk or frame. [optional]
            quality (str): Specifies the quality level of the requested data. [optional]
            type (str): Specifies the type of the requested data. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_data_endpoint.call_with_http_info(**kwargs)

    def retrieve_data_meta(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[DataMetaRead], urllib3.HTTPResponse]:
        """Get metainformation for media files in a task  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_data_meta(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (DataMetaRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_data_meta_endpoint.call_with_http_info(**kwargs)

    def retrieve_preview(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Get a preview image for a task  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_preview(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_preview_endpoint.call_with_http_info(**kwargs)

    def retrieve_status(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[RqStatus], urllib3.HTTPResponse]:
        """Get the creation status of a task  # noqa: E501

        This method is deprecated and will be removed in one of the next releases. To check status of task creation, use new common API for managing background operations: GET /api/requests/?action=create&task_id=<task_id>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_status(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (RqStatus, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_status_endpoint.call_with_http_info(**kwargs)

    def retrieve_validation_layout(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[TaskValidationLayoutRead], urllib3.HTTPResponse]:
        """Allows getting current validation configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_validation_layout(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (TaskValidationLayoutRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_validation_layout_endpoint.call_with_http_info(**kwargs)

    def update_annotations(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Replace task annotations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.update_annotations(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this task.

        Keyword Args:
            labeled_data_request (LabeledDataRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.update_annotations_endpoint.call_with_http_info(**kwargs)

