# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_cron_jobs_paginated.sql
import dataclasses
import datetime
from typing import Any, AsyncIterator, Iterator, Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_CRON_JOBS_PAGINATED = """-- name: get_cron_jobs_paginated \\:many
SELECT 
    jobid,
    schedule,
    command,
    active,
    jobname,
    job_source,
    activated_at,
    scheduled_jobs_confirmed_until
FROM hyrex_cron_job
ORDER BY jobid DESC
LIMIT :p1 OFFSET :p2
"""


@dataclasses.dataclass()
class GetCronJobsPaginatedParams:
    limit: int
    offset: int


@dataclasses.dataclass()
class GetCronJobsPaginatedRow:
    jobid: int
    schedule: Optional[str]
    command: str
    active: bool
    jobname: str
    job_source: Any
    activated_at: Optional[datetime.datetime]
    scheduled_jobs_confirmed_until: Optional[datetime.datetime]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_cron_jobs_paginated(self, arg: GetCronJobsPaginatedParams) -> Iterator[GetCronJobsPaginatedRow]:
        result = self._conn.execute(sqlalchemy.text(GET_CRON_JOBS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        for row in result:
            yield GetCronJobsPaginatedRow(
                jobid=row[0],
                schedule=row[1],
                command=row[2],
                active=row[3],
                jobname=row[4],
                job_source=row[5],
                activated_at=row[6],
                scheduled_jobs_confirmed_until=row[7],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_cron_jobs_paginated(self, arg: GetCronJobsPaginatedParams) -> AsyncIterator[GetCronJobsPaginatedRow]:
        result = await self._conn.stream(sqlalchemy.text(GET_CRON_JOBS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        async for row in result:
            yield GetCronJobsPaginatedRow(
                jobid=row[0],
                schedule=row[1],
                command=row[2],
                active=row[3],
                jobname=row[4],
                job_source=row[5],
                activated_at=row[6],
                scheduled_jobs_confirmed_until=row[7],
            )
