# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_executors_paginated.sql
import dataclasses
import datetime
from typing import Any, AsyncIterator, Iterator, List, Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_EXECUTORS_PAGINATED = """-- name: get_executors_paginated \\:many
SELECT 
    ROW_NUMBER() OVER (ORDER BY started DESC NULLS LAST) as row_number,
    id,
    name,
    worker_name,
    queue_pattern,
    queues,
    started,
    stopped,
    last_heartbeat,
    stats,
    status
FROM hyrex_executor
ORDER BY started DESC NULLS LAST
LIMIT :p1 OFFSET :p2
"""


@dataclasses.dataclass()
class GetExecutorsPaginatedParams:
    limit: int
    offset: int


@dataclasses.dataclass()
class GetExecutorsPaginatedRow:
    row_number: int
    id: uuid.UUID
    name: str
    worker_name: str
    queue_pattern: str
    queues: List[str]
    started: Optional[datetime.datetime]
    stopped: Optional[datetime.datetime]
    last_heartbeat: Optional[datetime.datetime]
    stats: Optional[Any]
    status: Any


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_executors_paginated(self, arg: GetExecutorsPaginatedParams) -> Iterator[GetExecutorsPaginatedRow]:
        result = self._conn.execute(sqlalchemy.text(GET_EXECUTORS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        for row in result:
            yield GetExecutorsPaginatedRow(
                row_number=row[0],
                id=row[1],
                name=row[2],
                worker_name=row[3],
                queue_pattern=row[4],
                queues=row[5],
                started=row[6],
                stopped=row[7],
                last_heartbeat=row[8],
                stats=row[9],
                status=row[10],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_executors_paginated(self, arg: GetExecutorsPaginatedParams) -> AsyncIterator[GetExecutorsPaginatedRow]:
        result = await self._conn.stream(sqlalchemy.text(GET_EXECUTORS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        async for row in result:
            yield GetExecutorsPaginatedRow(
                row_number=row[0],
                id=row[1],
                name=row[2],
                worker_name=row[3],
                queue_pattern=row[4],
                queues=row[5],
                started=row[6],
                stopped=row[7],
                last_heartbeat=row[8],
                stats=row[9],
                status=row[10],
            )
