# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: insert_workflow_run.sql
import dataclasses
from typing import Any, Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


INSERT_WORKFLOW_RUN = """-- name: insert_workflow_run \\:one
INSERT INTO hyrex_workflow_run (
    id,
    parent_id,
    workflow_name,
    args,
    queue,
    timeout_seconds,
    status,
    queued,
    started,
    last_heartbeat,
    idempotency_key
)
VALUES (:p1, NULL, :p2, :p3, :p4, :p5, 'RUNNING'\\:\\:workflow_run_status, now(), now(), now(), :p6)
RETURNING id
"""


@dataclasses.dataclass()
class InsertWorkflowRunParams:
    id: uuid.UUID
    workflow_name: str
    args: Any
    queue: str
    timeout_seconds: Optional[int]
    idempotency_key: Optional[str]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def insert_workflow_run(self, arg: InsertWorkflowRunParams) -> Optional[uuid.UUID]:
        row = self._conn.execute(sqlalchemy.text(INSERT_WORKFLOW_RUN), {
            "p1": arg.id,
            "p2": arg.workflow_name,
            "p3": arg.args,
            "p4": arg.queue,
            "p5": arg.timeout_seconds,
            "p6": arg.idempotency_key,
        }).first()
        if row is None:
            return None
        return row[0]


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def insert_workflow_run(self, arg: InsertWorkflowRunParams) -> Optional[uuid.UUID]:
        row = (await self._conn.execute(sqlalchemy.text(INSERT_WORKFLOW_RUN), {
            "p1": arg.id,
            "p2": arg.workflow_name,
            "p3": arg.args,
            "p4": arg.queue,
            "p5": arg.timeout_seconds,
            "p6": arg.idempotency_key,
        })).first()
        if row is None:
            return None
        return row[0]
