# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: pull_active_cron_expressions.sql
import dataclasses
import datetime
from typing import AsyncIterator, Iterator, Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


PULL_ACTIVE_CRON_EXPRESSIONS = """-- name: pull_active_cron_expressions \\:many
SELECT jobid,
       schedule,
       command,
       active,
       jobname,
       activated_at,
       scheduled_jobs_confirmed_until,
       should_backfill
FROM hyrex_cron_job
WHERE active = true
"""


@dataclasses.dataclass()
class PullActiveCronExpressionsParams:

    pass

@dataclasses.dataclass()
class PullActiveCronExpressionsRow:
    jobid: int
    schedule: Optional[str]
    command: str
    active: bool
    jobname: str
    activated_at: Optional[datetime.datetime]
    scheduled_jobs_confirmed_until: Optional[datetime.datetime]
    should_backfill: Optional[bool]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def pull_active_cron_expressions(self, arg: PullActiveCronExpressionsParams) -> Iterator[PullActiveCronExpressionsRow]:
        result = self._conn.execute(sqlalchemy.text(PULL_ACTIVE_CRON_EXPRESSIONS))
        for row in result:
            yield PullActiveCronExpressionsRow(
                jobid=row[0],
                schedule=row[1],
                command=row[2],
                active=row[3],
                jobname=row[4],
                activated_at=row[5],
                scheduled_jobs_confirmed_until=row[6],
                should_backfill=row[7],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def pull_active_cron_expressions(self, arg: PullActiveCronExpressionsParams) -> AsyncIterator[PullActiveCronExpressionsRow]:
        result = await self._conn.stream(sqlalchemy.text(PULL_ACTIVE_CRON_EXPRESSIONS))
        async for row in result:
            yield PullActiveCronExpressionsRow(
                jobid=row[0],
                schedule=row[1],
                command=row[2],
                active=row[3],
                jobname=row[4],
                activated_at=row[5],
                scheduled_jobs_confirmed_until=row[6],
                should_backfill=row[7],
            )
