# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: register_executor.sql
import dataclasses
from typing import List
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


REGISTER_EXECUTOR = """-- name: register_executor \\:exec
INSERT INTO hyrex_executor (id,
                            name,
                            queue_pattern,
                            queues,
                            worker_name,
                            started,
                            stopped,
                            last_heartbeat,
                            status)
VALUES (:p1, :p2, :p3, :p4, :p5, CURRENT_TIMESTAMP, null, CURRENT_TIMESTAMP, 'RUNNING'\\:\\:executor_status)
"""


@dataclasses.dataclass()
class RegisterExecutorParams:
    id: uuid.UUID
    name: str
    queue_pattern: str
    queues: List[str]
    worker_name: str


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def register_executor(self, arg: RegisterExecutorParams) -> None:
        self._conn.execute(sqlalchemy.text(REGISTER_EXECUTOR), {
            "p1": arg.id,
            "p2": arg.name,
            "p3": arg.queue_pattern,
            "p4": arg.queues,
            "p5": arg.worker_name,
        })


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def register_executor(self, arg: RegisterExecutorParams) -> None:
        await self._conn.execute(sqlalchemy.text(REGISTER_EXECUTOR), {
            "p1": arg.id,
            "p2": arg.name,
            "p3": arg.queue_pattern,
            "p4": arg.queues,
            "p5": arg.worker_name,
        })
