# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: register_hype_cron_job.sql
import dataclasses
from typing import Any, Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


REGISTER_HYPE_CRON_JOB = """-- name: register_hype_cron_job \\:exec
INSERT INTO hype_cron_job (jobname, schedule, command_type, command_params, active, should_backfill)
VALUES (:p1, :p2, :p3, :p4, :p5, :p6)
ON CONFLICT (jobname)
DO UPDATE SET 
    schedule = EXCLUDED.schedule,
    command_type = EXCLUDED.command_type,
    command_params = EXCLUDED.command_params,
    active = CASE 
        WHEN hype_cron_job.active = false THEN hype_cron_job.active  -- Preserve deactivated state
        ELSE EXCLUDED.active  -- Otherwise use the new value
    END,
    should_backfill = EXCLUDED.should_backfill
"""


@dataclasses.dataclass()
class RegisterHypeCronJobParams:
    jobname: str
    schedule: Optional[str]
    command_type: Any
    command_params: Any
    active: bool
    should_backfill: Optional[bool]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def register_hype_cron_job(self, arg: RegisterHypeCronJobParams) -> None:
        self._conn.execute(sqlalchemy.text(REGISTER_HYPE_CRON_JOB), {
            "p1": arg.jobname,
            "p2": arg.schedule,
            "p3": arg.command_type,
            "p4": arg.command_params,
            "p5": arg.active,
            "p6": arg.should_backfill,
        })


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def register_hype_cron_job(self, arg: RegisterHypeCronJobParams) -> None:
        await self._conn.execute(sqlalchemy.text(REGISTER_HYPE_CRON_JOB), {
            "p1": arg.jobname,
            "p2": arg.schedule,
            "p3": arg.command_type,
            "p4": arg.command_params,
            "p5": arg.active,
            "p6": arg.should_backfill,
        })
