{{
    config(
        materialized='incremental',
        incremental_strategy='incremental_by_time_range',
        cluster_by=['ds'],
        time_column='ds',
    )
}}

SELECT
  w.ds as ds,
  w.waiter_id as waiter_id,
  wn.name as waiter_name
FROM {{ ref('waiters') }} AS w
JOIN {{ ref('customers') }} as c ON w.waiter_id = c.customer_id
JOIN {{ ref('waiter_names') }} as wn ON w.waiter_id = wn.id
