#  Copyright (c) 2023 BlackRock, Inc.
#  All Rights Reserved.

import logging
import smtplib
from email.message import EmailMessage

from ingen.utils.properties import properties

logger = logging.getLogger(__name__)


def send_email(to_address, body, subject):
    """
    to_address: email address of the recipients
    from_address: sender's email address
    file_path: path of the file to be sent as an attachment
    body: body of the email
    subject: subject of email

    """
    body = body + "\n...This is an autogenerated email please do not reply to this email..."
    msg = EmailMessage()
    msg['From'] = properties.get_property('from_email')
    msg['To'] = to_address
    msg['Subject'] = subject
    msg.set_content(body)

    with smtplib.SMTP(determine_mailserver()) as server:
        server.send_message(msg)
        logger.info(f"Email has been sent successfully to {str(to_address)}.")


def determine_mailserver():
    return properties.get_property('mail.smtp.host')
