import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/location#feature DataIonoscloudLocation#feature}
    */
    readonly feature?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/location#name DataIonoscloudLocation#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/location#timeouts DataIonoscloudLocation#timeouts}
    */
    readonly timeouts?: DataIonoscloudLocationTimeouts;
}
export interface DataIonoscloudLocationCpuArchitecture {
}
export declare function dataIonoscloudLocationCpuArchitectureToTerraform(struct?: DataIonoscloudLocationCpuArchitecture): any;
export declare class DataIonoscloudLocationCpuArchitectureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudLocationCpuArchitecture | undefined;
    set internalValue(value: DataIonoscloudLocationCpuArchitecture | undefined);
    get cpuFamily(): string;
    get maxCores(): number;
    get maxRam(): number;
    get vendor(): string;
}
export declare class DataIonoscloudLocationCpuArchitectureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudLocationCpuArchitectureOutputReference;
}
export interface DataIonoscloudLocationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/location#create DataIonoscloudLocation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/location#default DataIonoscloudLocation#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/location#delete DataIonoscloudLocation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/location#update DataIonoscloudLocation#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudLocationTimeoutsToTerraform(struct?: DataIonoscloudLocationTimeoutsOutputReference | DataIonoscloudLocationTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudLocationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudLocationTimeouts | undefined;
    set internalValue(value: DataIonoscloudLocationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/location ionoscloud_location}
*/
export declare class DataIonoscloudLocation extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_location";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/location ionoscloud_location} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudLocationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudLocationConfig);
    private _cpuArchitecture;
    get cpuArchitecture(): DataIonoscloudLocationCpuArchitectureList;
    private _feature?;
    get feature(): string;
    set feature(value: string);
    resetFeature(): void;
    get featureInput(): string | undefined;
    get id(): string;
    get imageAliases(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudLocationTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudLocationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudLocationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
