import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#edit_privilege DataIonoscloudShare#edit_privilege}
    */
    readonly editPrivilege?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#group_id DataIonoscloudShare#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#id DataIonoscloudShare#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#resource_id DataIonoscloudShare#resource_id}
    */
    readonly resourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#share_privilege DataIonoscloudShare#share_privilege}
    */
    readonly sharePrivilege?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#timeouts DataIonoscloudShare#timeouts}
    */
    readonly timeouts?: DataIonoscloudShareTimeouts;
}
export interface DataIonoscloudShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#create DataIonoscloudShare#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#default DataIonoscloudShare#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#delete DataIonoscloudShare#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/share#update DataIonoscloudShare#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudShareTimeoutsToTerraform(struct?: DataIonoscloudShareTimeoutsOutputReference | DataIonoscloudShareTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudShareTimeouts | undefined;
    set internalValue(value: DataIonoscloudShareTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/share ionoscloud_share}
*/
export declare class DataIonoscloudShare extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_share";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/share ionoscloud_share} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudShareConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudShareConfig);
    private _editPrivilege?;
    get editPrivilege(): boolean | cdktf.IResolvable;
    set editPrivilege(value: boolean | cdktf.IResolvable);
    resetEditPrivilege(): void;
    get editPrivilegeInput(): boolean | cdktf.IResolvable | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _sharePrivilege?;
    get sharePrivilege(): boolean | cdktf.IResolvable;
    set sharePrivilege(value: boolean | cdktf.IResolvable);
    resetSharePrivilege(): void;
    get sharePrivilegeInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudShareTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
