import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/user#email DataIonoscloudUser#email}
    */
    readonly email?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/user#id DataIonoscloudUser#id}
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/user#timeouts DataIonoscloudUser#timeouts}
    */
    readonly timeouts?: DataIonoscloudUserTimeouts;
}
export interface DataIonoscloudUserGroups {
}
export declare function dataIonoscloudUserGroupsToTerraform(struct?: DataIonoscloudUserGroups): any;
export declare class DataIonoscloudUserGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudUserGroups | undefined;
    set internalValue(value: DataIonoscloudUserGroups | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataIonoscloudUserGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudUserGroupsOutputReference;
}
export interface DataIonoscloudUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/user#create DataIonoscloudUser#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/user#default DataIonoscloudUser#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/user#delete DataIonoscloudUser#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/user#update DataIonoscloudUser#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudUserTimeoutsToTerraform(struct?: DataIonoscloudUserTimeoutsOutputReference | DataIonoscloudUserTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudUserTimeouts | undefined;
    set internalValue(value: DataIonoscloudUserTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/user ionoscloud_user}
*/
export declare class DataIonoscloudUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/user ionoscloud_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudUserConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudUserConfig);
    get active(): cdktf.IResolvable;
    get administrator(): cdktf.IResolvable;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    get firstName(): string;
    get forceSecAuth(): cdktf.IResolvable;
    private _groups;
    get groups(): DataIonoscloudUserGroupsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastName(): string;
    get s3CanonicalUserId(): string;
    get secAuthActive(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataIonoscloudUserTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
