# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppPasswordArgs', 'AppPassword']

@pulumi.input_type
class AppPasswordArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppPassword resource.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the app password.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The roles to assign to the app password. Allowed values are 'Member' and 'Admin'. Only valid with service-type app passwords.
        :param pulumi.Input[_builtins.str] type: The type of the app password: personal or service.
        :param pulumi.Input[_builtins.str] user: The user to associate with the app password. Only valid with service-type app passwords.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable name for the app password.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The roles to assign to the app password. Allowed values are 'Member' and 'Admin'. Only valid with service-type app passwords.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the app password: personal or service.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user to associate with the app password. Only valid with service-type app passwords.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _AppPasswordState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppPassword resources.
        :param pulumi.Input[_builtins.str] created_at: The time at which the app password was created.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the app password.
        :param pulumi.Input[_builtins.str] password: The value of the app password.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The roles to assign to the app password. Allowed values are 'Member' and 'Admin'. Only valid with service-type app passwords.
        :param pulumi.Input[_builtins.str] type: The type of the app password: personal or service.
        :param pulumi.Input[_builtins.str] user: The user to associate with the app password. Only valid with service-type app passwords.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the app password was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable name for the app password.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the app password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The roles to assign to the app password. Allowed values are 'Member' and 'Admin'. Only valid with service-type app passwords.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the app password: personal or service.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user to associate with the app password. Only valid with service-type app passwords.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("materialize:index/appPassword:AppPassword")
class AppPassword(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a service user and app password
        production_dashboard = materialize.Role("productionDashboard")
        production_dashboard_app_password = materialize.AppPassword("productionDashboardAppPassword",
            type="service",
            user=production_dashboard.name,
            roles=["Member"])
        database_grant_usage = materialize.GrantDatabase("databaseGrantUsage",
            role_name=production_dashboard.name,
            privilege="USAGE",
            database_name="production_analytics")
        # Create a personal app password for the current user
        example_app_password = materialize.AppPassword("exampleAppPassword")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        App passwords can be imported using the app password id:

        ```sh
        $ pulumi import materialize:index/appPassword:AppPassword example_app_password <app_password_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the app password.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The roles to assign to the app password. Allowed values are 'Member' and 'Admin'. Only valid with service-type app passwords.
        :param pulumi.Input[_builtins.str] type: The type of the app password: personal or service.
        :param pulumi.Input[_builtins.str] user: The user to associate with the app password. Only valid with service-type app passwords.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AppPasswordArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a service user and app password
        production_dashboard = materialize.Role("productionDashboard")
        production_dashboard_app_password = materialize.AppPassword("productionDashboardAppPassword",
            type="service",
            user=production_dashboard.name,
            roles=["Member"])
        database_grant_usage = materialize.GrantDatabase("databaseGrantUsage",
            role_name=production_dashboard.name,
            privilege="USAGE",
            database_name="production_analytics")
        # Create a personal app password for the current user
        example_app_password = materialize.AppPassword("exampleAppPassword")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        App passwords can be imported using the app password id:

        ```sh
        $ pulumi import materialize:index/appPassword:AppPassword example_app_password <app_password_id>
        ```

        :param str resource_name: The name of the resource.
        :param AppPasswordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppPasswordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppPasswordArgs.__new__(AppPasswordArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["roles"] = roles
            __props__.__dict__["type"] = type
            __props__.__dict__["user"] = user
            __props__.__dict__["created_at"] = None
            __props__.__dict__["password"] = None
            __props__.__dict__["secret"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AppPassword, __self__).__init__(
            'materialize:index/appPassword:AppPassword',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            secret: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppPassword':
        """
        Get an existing AppPassword resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The time at which the app password was created.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the app password.
        :param pulumi.Input[_builtins.str] password: The value of the app password.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The roles to assign to the app password. Allowed values are 'Member' and 'Admin'. Only valid with service-type app passwords.
        :param pulumi.Input[_builtins.str] type: The type of the app password: personal or service.
        :param pulumi.Input[_builtins.str] user: The user to associate with the app password. Only valid with service-type app passwords.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppPasswordState.__new__(_AppPasswordState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["roles"] = roles
        __props__.__dict__["secret"] = secret
        __props__.__dict__["type"] = type
        __props__.__dict__["user"] = user
        return AppPassword(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the app password was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable name for the app password.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the app password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The roles to assign to the app password. Allowed values are 'Member' and 'Admin'. Only valid with service-type app passwords.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the app password: personal or service.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user to associate with the app password. Only valid with service-type app passwords.
        """
        return pulumi.get(self, "user")

