# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudRegionArgs', 'CloudRegion']

@pulumi.input_type
class CloudRegionArgs:
    def __init__(__self__, *,
                 region_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a CloudRegion resource.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region to manage. Example: aws/us-west-2
        """
        pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region to manage. Example: aws/us-west-2
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_id", value)


@pulumi.input_type
class _CloudRegionState:
    def __init__(__self__, *,
                 enabled_at: Optional[pulumi.Input[_builtins.str]] = None,
                 http_address: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 resolvable: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudRegion resources.
        :param pulumi.Input[_builtins.str] enabled_at: The timestamp when the region was enabled.
        :param pulumi.Input[_builtins.str] http_address: The HTTP address of the region.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region to manage. Example: aws/us-west-2
        :param pulumi.Input[_builtins.bool] region_state: The state of the region. True if enabled, false otherwise.
        :param pulumi.Input[_builtins.bool] resolvable: Indicates if the region is resolvable.
        :param pulumi.Input[_builtins.str] sql_address: The SQL address of the region.
        """
        if enabled_at is not None:
            pulumi.set(__self__, "enabled_at", enabled_at)
        if http_address is not None:
            pulumi.set(__self__, "http_address", http_address)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if region_state is not None:
            pulumi.set(__self__, "region_state", region_state)
        if resolvable is not None:
            pulumi.set(__self__, "resolvable", resolvable)
        if sql_address is not None:
            pulumi.set(__self__, "sql_address", sql_address)

    @_builtins.property
    @pulumi.getter(name="enabledAt")
    def enabled_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the region was enabled.
        """
        return pulumi.get(self, "enabled_at")

    @enabled_at.setter
    def enabled_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled_at", value)

    @_builtins.property
    @pulumi.getter(name="httpAddress")
    def http_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP address of the region.
        """
        return pulumi.get(self, "http_address")

    @http_address.setter
    def http_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_address", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region to manage. Example: aws/us-west-2
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="regionState")
    def region_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The state of the region. True if enabled, false otherwise.
        """
        return pulumi.get(self, "region_state")

    @region_state.setter
    def region_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "region_state", value)

    @_builtins.property
    @pulumi.getter
    def resolvable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the region is resolvable.
        """
        return pulumi.get(self, "resolvable")

    @resolvable.setter
    def resolvable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resolvable", value)

    @_builtins.property
    @pulumi.getter(name="sqlAddress")
    def sql_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SQL address of the region.
        """
        return pulumi.get(self, "sql_address")

    @sql_address.setter
    def sql_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_address", value)


@pulumi.type_token("materialize:index/cloudRegion:CloudRegion")
class CloudRegion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The region resource allows you to manage regions in Materialize. When a new region is created, it automatically includes an 'xsmall' quickstart cluster as part of the initialization process. Users are billed for this quickstart cluster from the moment the region is created. To avoid unnecessary charges, you can connect to the new region and drop the quickstart cluster if it is not needed. Please note that disabling a region cannot be achieved directly through this provider. If you need to disable a region, contact Materialize support for assistance. This process ensures that any necessary cleanup and billing adjustments are handled properly.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example = materialize.CloudRegion("example", region_id="aws/us-east-1")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Regions can be imported using the `aws/` prefix followed by the region name.

        ```sh
        $ pulumi import materialize:index/cloudRegion:CloudRegion example_region aws/us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region to manage. Example: aws/us-west-2
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudRegionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The region resource allows you to manage regions in Materialize. When a new region is created, it automatically includes an 'xsmall' quickstart cluster as part of the initialization process. Users are billed for this quickstart cluster from the moment the region is created. To avoid unnecessary charges, you can connect to the new region and drop the quickstart cluster if it is not needed. Please note that disabling a region cannot be achieved directly through this provider. If you need to disable a region, contact Materialize support for assistance. This process ensures that any necessary cleanup and billing adjustments are handled properly.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example = materialize.CloudRegion("example", region_id="aws/us-east-1")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Regions can be imported using the `aws/` prefix followed by the region name.

        ```sh
        $ pulumi import materialize:index/cloudRegion:CloudRegion example_region aws/us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param CloudRegionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudRegionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudRegionArgs.__new__(CloudRegionArgs)

            if region_id is None and not opts.urn:
                raise TypeError("Missing required property 'region_id'")
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["enabled_at"] = None
            __props__.__dict__["http_address"] = None
            __props__.__dict__["region_state"] = None
            __props__.__dict__["resolvable"] = None
            __props__.__dict__["sql_address"] = None
        super(CloudRegion, __self__).__init__(
            'materialize:index/cloudRegion:CloudRegion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled_at: Optional[pulumi.Input[_builtins.str]] = None,
            http_address: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_state: Optional[pulumi.Input[_builtins.bool]] = None,
            resolvable: Optional[pulumi.Input[_builtins.bool]] = None,
            sql_address: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudRegion':
        """
        Get an existing CloudRegion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] enabled_at: The timestamp when the region was enabled.
        :param pulumi.Input[_builtins.str] http_address: The HTTP address of the region.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region to manage. Example: aws/us-west-2
        :param pulumi.Input[_builtins.bool] region_state: The state of the region. True if enabled, false otherwise.
        :param pulumi.Input[_builtins.bool] resolvable: Indicates if the region is resolvable.
        :param pulumi.Input[_builtins.str] sql_address: The SQL address of the region.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudRegionState.__new__(_CloudRegionState)

        __props__.__dict__["enabled_at"] = enabled_at
        __props__.__dict__["http_address"] = http_address
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["region_state"] = region_state
        __props__.__dict__["resolvable"] = resolvable
        __props__.__dict__["sql_address"] = sql_address
        return CloudRegion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enabledAt")
    def enabled_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the region was enabled.
        """
        return pulumi.get(self, "enabled_at")

    @_builtins.property
    @pulumi.getter(name="httpAddress")
    def http_address(self) -> pulumi.Output[_builtins.str]:
        """
        The HTTP address of the region.
        """
        return pulumi.get(self, "http_address")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region to manage. Example: aws/us-west-2
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="regionState")
    def region_state(self) -> pulumi.Output[_builtins.bool]:
        """
        The state of the region. True if enabled, false otherwise.
        """
        return pulumi.get(self, "region_state")

    @_builtins.property
    @pulumi.getter
    def resolvable(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if the region is resolvable.
        """
        return pulumi.get(self, "resolvable")

    @_builtins.property
    @pulumi.getter(name="sqlAddress")
    def sql_address(self) -> pulumi.Output[_builtins.str]:
        """
        The SQL address of the region.
        """
        return pulumi.get(self, "sql_address")

